/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.List;
import org.apache.james.jdkim.api.Headers;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.exceptions.PermFailException;

public abstract class DKIMCommon {
    protected static boolean deepDebug;

    protected static void updateSignature(Signature signature, boolean relaxed, boolean ischeduleRelaxed, CharSequence header, String fv) throws SignatureException {
        if (relaxed | ischeduleRelaxed) {
            if (deepDebug) {
                DKIMCommon.trace("#" + header.toString().toLowerCase() + ":-");
            }
            signature.update(header.toString().toLowerCase().getBytes());
            signature.update(":".getBytes());
            String headerValue = fv.substring(fv.indexOf(58) + 1);
            headerValue = headerValue.replaceAll("\r\n[\t ]", " ");
            headerValue = headerValue.replaceAll("[\t ]+", " ");
            if (ischeduleRelaxed) {
                headerValue = headerValue.replaceAll(" , ", ",");
            }
            headerValue = headerValue.trim();
            signature.update(headerValue.getBytes());
            if (deepDebug) {
                DKIMCommon.trace("#" + headerValue + "#");
            }
        } else {
            signature.update(fv.getBytes());
            if (deepDebug) {
                DKIMCommon.trace("#" + fv + "#");
            }
        }
    }

    protected static void signatureCheck(Headers h, SignatureRecord sign, List<CharSequence> headers, Signature signature) throws SignatureException, PermFailException {
        String headerCanonicalisation = sign.getHeaderCanonicalisationMethod();
        boolean relaxedHeaders = "relaxed".equals(headerCanonicalisation);
        boolean ischeduleRelaxedHeaders = "ischedule-relaxed".equals(headerCanonicalisation);
        if (!(relaxedHeaders || ischeduleRelaxedHeaders || "simple".equals(headerCanonicalisation))) {
            throw new PermFailException("Unsupported canonicalization algorithm: " + headerCanonicalisation);
        }
        if (ischeduleRelaxedHeaders) {
            for (CharSequence header : headers) {
                String hdr = header.toString();
                List<String> hl = h.getFields(hdr);
                if (hl == null || hl.size() == 0) continue;
                if (hl.size() > 1) {
                    throw new PermFailException("header canonicalization algorithm failed: Got multiple headers for " + hdr);
                }
                DKIMCommon.trace("========= Signing header " + hdr);
                DKIMCommon.updateSignature(signature, false, true, header, hl.get(0));
                signature.update("\r\n".getBytes());
            }
        } else {
            HashMap<String, Integer> processedHeader = new HashMap<String, Integer>();
            for (CharSequence header : headers) {
                int doneHeaders;
                String hdr = header.toString();
                List<String> hl = h.getFields(hdr);
                if (hl == null || hl.size() == 0) continue;
                Integer done = (Integer)processedHeader.get(hdr);
                if (done == null) {
                    done = 0;
                }
                if ((doneHeaders = done + 1) > hl.size()) continue;
                String fv = hl.get(hl.size() - doneHeaders);
                DKIMCommon.updateSignature(signature, relaxedHeaders, false, header, fv);
                signature.update("\r\n".getBytes());
                processedHeader.put(hdr, new Integer(doneHeaders));
            }
        }
        String signatureStub = "DKIM-Signature:" + sign.toUnsignedString();
        DKIMCommon.updateSignature(signature, relaxedHeaders, ischeduleRelaxedHeaders, "dkim-signature", signatureStub);
    }

    public static void streamCopy(InputStream bodyIs, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[2048];
        while ((read = bodyIs.read(buffer)) > 0) {
            out.write(buffer, 0, read);
        }
        bodyIs.close();
        out.close();
    }

    protected static void debugMsg(String msg) {
        System.out.println(msg);
    }

    protected static void trace(String msg) {
        System.out.println(msg);
    }
}

