/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.db.conversion.converter;

import java.util.concurrent.LinkedBlockingQueue;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.lang.ThreadTasks$;
import org.beangle.commons.lang.time.Stopwatch;
import org.beangle.commons.logging.Logger;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.meta.Table;
import org.beangle.db.conversion.Converter;
import org.beangle.db.conversion.DataWrapper;
import org.beangle.db.conversion.converter.TableConverter$;
import scala.Function0;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u00015\u0011a\u0002V1cY\u0016\u001cuN\u001c<feR,'O\u0003\u0002\u0004\t\u0005I1m\u001c8wKJ$XM\u001d\u0006\u0003\u000b\u0019\t!bY8om\u0016\u00148/[8o\u0015\t9\u0001\"\u0001\u0002eE*\u0011\u0011BC\u0001\bE\u0016\fgn\u001a7f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f)a\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005!\u0011BA\f\u0005\u0005%\u0019uN\u001c<feR,'\u000f\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u00059An\\4hS:<'BA\u000f\t\u0003\u001d\u0019w.\\7p]NL!a\b\u000e\u0003\u000f1{wmZ5oO\"A\u0011\u0005\u0001BC\u0002\u0013\u0005!%\u0001\u0004t_V\u00148-Z\u000b\u0002GA\u0011Q\u0003J\u0005\u0003K\u0011\u00111\u0002R1uC^\u0013\u0018\r\u001d9fe\"Aq\u0005\u0001B\u0001B\u0003%1%A\u0004t_V\u00148-\u001a\u0011\t\u0011%\u0002!Q1A\u0005\u0002\t\na\u0001^1sO\u0016$\b\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u000fQ\f'oZ3uA!AQ\u0006\u0001BC\u0002\u0013\u0005a&A\u0004uQJ,\u0017\rZ:\u0016\u0003=\u0002\"a\u0004\u0019\n\u0005E\u0002\"aA%oi\"A1\u0007\u0001B\u0001B\u0003%q&\u0001\u0005uQJ,\u0017\rZ:!\u0011\u0015)\u0004\u0001\"\u00017\u0003\u0019a\u0014N\\5u}Q!q'\u000f\u001e<!\tA\u0004!D\u0001\u0003\u0011\u0015\tC\u00071\u0001$\u0011\u0015IC\u00071\u0001$\u0011\u001diC\u0007%AA\u0002=Bq!\u0010\u0001C\u0002\u0013\u0005a(\u0001\u0004uC\ndWm]\u000b\u0002\u007fA\u0019\u0001)R$\u000e\u0003\u0005S!AQ\"\u0002\u000f5,H/\u00192mK*\u0011A\tE\u0001\u000bG>dG.Z2uS>t\u0017B\u0001$B\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u0005\u001f!S%*\u0003\u0002J!\t1A+\u001e9mKJ\u0002\"a\u0013*\u000e\u00031S!!\u0014(\u0002\t5,G/\u0019\u0006\u0003\u001fB\u000bAA\u001b3cG*\u0011\u0011\u000bC\u0001\u0005I\u0006$\u0018-\u0003\u0002T\u0019\n)A+\u00192mK\"1Q\u000b\u0001Q\u0001\n}\nq\u0001^1cY\u0016\u001c\b\u0005C\u0003X\u0001\u0011E\u0001,\u0001\u0005bI\u0012$\u0016M\u00197f)\tIF\f\u0005\u0002\u00105&\u00111\f\u0005\u0002\u0005+:LG\u000fC\u0003^-\u0002\u0007q)\u0001\u0003qC&\u0014\b\"B0\u0001\t\u0003\u0001\u0017AB1eI\u0006cG\u000e\u0006\u0002ZC\")!M\u0018a\u0001G\u0006)\u0001/Y5sgB\u0019A\r\\$\u000f\u0005\u0015TgB\u00014j\u001b\u00059'B\u00015\r\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002l!\u00059\u0001/Y2lC\u001e,\u0017BA7o\u0005\r\u0019V-\u001d\u0006\u0003WBAQ\u0001\u001d\u0001\u0005\u0002E\fQA]3tKR$\u0012!\u0017\u0005\u0006g\u0002!\t!]\u0001\u0006gR\f'\u000f\u001e\u0004\u0005k\u0002\u0001aOA\u0006D_:4XM\u001d;UCN\\7c\u0001;x\u007fB\u0011\u00010`\u0007\u0002s*\u0011!p_\u0001\u0005Y\u0006twMC\u0001}\u0003\u0011Q\u0017M^1\n\u0005yL(AB(cU\u0016\u001cG\u000fE\u0002y\u0003\u0003I1!a\u0001z\u0005!\u0011VO\u001c8bE2,\u0007\u0002C\u0011u\u0005\u000b\u0007I\u0011\u0001\u0012\t\u0011\u001d\"(\u0011!Q\u0001\n\rB\u0001\"\u000b;\u0003\u0006\u0004%\tA\t\u0005\tWQ\u0014\t\u0011)A\u0005G!Q\u0011q\u0002;\u0003\u0006\u0004%\t!!\u0005\u0002\r\t,hMZ3s+\t\t\u0019\u0002E\u0003\u0002\u0016\u0005}q)\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003;Y\u0018\u0001B;uS2LA!!\t\u0002\u0018\t\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vK\"Q\u0011Q\u0005;\u0003\u0002\u0003\u0006I!a\u0005\u0002\u000f\t,hMZ3sA!1Q\u0007\u001eC\u0001\u0003S!\u0002\"a\u000b\u00020\u0005E\u00121\u0007\t\u0004\u0003[!X\"\u0001\u0001\t\r\u0005\n9\u00031\u0001$\u0011\u0019I\u0013q\u0005a\u0001G!A\u0011qBA\u0014\u0001\u0004\t\u0019\u0002\u0003\u0004\u00028Q$\t!]\u0001\u0004eVt\u0007bBA\u001ei\u0012%\u0011QH\u0001\u0015GJ,\u0017\r^3PeJ+\u0007\u000f\\1dKR\u000b'\r\\3\u0015\t\u0005}\u0012Q\t\t\u0004\u001f\u0005\u0005\u0013bAA\"!\t9!i\\8mK\u0006t\u0007bBA$\u0003s\u0001\rAS\u0001\u0006i\u0006\u0014G.\u001a\u0005\b\u0003\u0017\"H\u0011AA'\u0003\u001d\u0019wN\u001c<feR$2!WA(\u0011\u0019i\u0016\u0011\na\u0001\u000f\u001eI\u00111\u000b\u0002\u0002\u0002#\u0005\u0011QK\u0001\u000f)\u0006\u0014G.Z\"p]Z,'\u000f^3s!\rA\u0014q\u000b\u0004\t\u0003\t\t\t\u0011#\u0001\u0002ZM\u0019\u0011q\u000b\b\t\u000fU\n9\u0006\"\u0001\u0002^Q\u0011\u0011Q\u000b\u0005\u000b\u0003C\n9&%A\u0005\u0002\u0005\r\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002f)\u001aq&a\u001a,\u0005\u0005%\u0004\u0003BA6\u0003kj!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001d\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\niGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class TableConverter
implements Converter,
Logging {
    private final DataWrapper source;
    private final DataWrapper target;
    private final int threads;
    private final ListBuffer<Tuple2<Table, Table>> tables;
    private final Logger logger;

    public static int $lessinit$greater$default$3() {
        return TableConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public DataWrapper source() {
        return this.source;
    }

    @Override
    public DataWrapper target() {
        return this.target;
    }

    public int threads() {
        return this.threads;
    }

    public ListBuffer<Tuple2<Table, Table>> tables() {
        return this.tables;
    }

    public void addTable(Tuple2<Table, Table> pair) {
        this.tables().$plus$eq(pair);
    }

    public void addAll(Seq<Tuple2<Table, Table>> pairs) {
        this.tables().$plus$plus$eq(pairs);
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
        Stopwatch watch = new Stopwatch(true);
        int tableCount = this.tables().length();
        LinkedBlockingQueue<Tuple2<Table, Table>> buffer = new LinkedBlockingQueue<Tuple2<Table, Table>>();
        buffer.addAll(JavaConversions$.MODULE$.asJavaCollection((Iterable)this.tables().sortWith((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Table, Table> x$1, Tuple2<Table, Table> x$2) {
                return ((Table)x$1._1()).name().$greater((Object)((Table)x$2._1()).name());
            }
        })));
        this.logger().info((Function0)new Serializable(this, tableCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableConverter $outer;
            private final int tableCount$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start ", " tables data replication in ", " threads..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.tableCount$1), BoxesRunTime.boxToInteger((int)this.$outer.threads())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableCount$1 = tableCount$1;
            }
        });
        ThreadTasks$.MODULE$.start((Runnable)new ConvertTask(this, this.source(), this.target(), buffer), this.threads(), ThreadTasks$.MODULE$.start$default$3());
        this.logger().info((Function0)new Serializable(this, watch, tableCount){
            public static final long serialVersionUID = 0L;
            private final Stopwatch watch$1;
            private final int tableCount$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"End ", " tables data replication,using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.tableCount$1), this.watch$1}));
            }
            {
                this.watch$1 = watch$1;
                this.tableCount$1 = tableCount$1;
            }
        });
    }

    public TableConverter(DataWrapper source, DataWrapper target, int threads) {
        this.source = source;
        this.target = target;
        this.threads = threads;
        Logging.class.$init$((Logging)this);
        this.tables = new ListBuffer();
    }

    public class ConvertTask
    implements Runnable {
        private final DataWrapper source;
        private final DataWrapper target;
        private final LinkedBlockingQueue<Tuple2<Table, Table>> buffer;
        public final /* synthetic */ TableConverter $outer;

        public DataWrapper source() {
            return this.source;
        }

        public DataWrapper target() {
            return this.target;
        }

        public LinkedBlockingQueue<Tuple2<Table, Table>> buffer() {
            return this.buffer;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (!this.buffer().isEmpty()) {
                try {
                    Tuple2<Table, Table> p = this.buffer().poll();
                    if (p == null) continue;
                    this.convert(p);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                catch (Exception exception) {
                    this.org$beangle$db$conversion$converter$TableConverter$ConvertTask$$$outer().logger().error((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Error in convertion ";
                        }
                    }, (Function0)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$1;

                        public final Exception apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    continue;
                }
                break;
            }
            return;
        }

        private boolean createOrReplaceTable(Table table) {
            if (this.target().drop(table)) {
                if (this.target().create(table)) {
                    this.org$beangle$db$conversion$converter$TableConverter$ConvertTask$$$outer().logger().info((Function0)new Serializable(this, table){
                        public static final long serialVersionUID = 0L;
                        private final Table table$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Create table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1.name()}));
                        }
                        {
                            this.table$1 = table$1;
                        }
                    });
                    return true;
                }
                this.org$beangle$db$conversion$converter$TableConverter$ConvertTask$$$outer().logger().error((Function0)new Serializable(this, table){
                    public static final long serialVersionUID = 0L;
                    private final Table table$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Create table ", " failure."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1.name()}));
                    }
                    {
                        this.table$1 = table$1;
                    }
                });
            }
            return false;
        }

        public void convert(Tuple2<Table, Table> pair) {
            block10: {
                Table srcTable = (Table)pair._1();
                Table targetTable = (Table)pair._2();
                try {
                    if (this.createOrReplaceTable(targetTable)) {
                        IntRef count = IntRef.create((int)this.source().count(srcTable));
                        if (count.elem == 0) {
                            this.target().save(targetTable, (Seq<Seq<?>>)List$.MODULE$.empty());
                            this.org$beangle$db$conversion$converter$TableConverter$ConvertTask$$$outer().logger().info((Function0)new Serializable(this, targetTable){
                                public static final long serialVersionUID = 0L;
                                private final Table targetTable$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Insert ", "(0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTable$1}));
                                }
                                {
                                    this.targetTable$1 = targetTable$1;
                                }
                            });
                        } else {
                            IntRef curr = IntRef.create((int)0);
                            int pageIndex = 0;
                            while (curr.elem < count.elem) {
                                PageLimit limit = new PageLimit(pageIndex + 1, 10000);
                                Seq<Seq<?>> data = this.source().supportLimit() && srcTable.primaryKey() != null ? this.source().get(srcTable, limit) : this.source().get(srcTable);
                                boolean breakable = false;
                                if (data.isEmpty()) {
                                    this.org$beangle$db$conversion$converter$TableConverter$ConvertTask$$$outer().logger().error((Function0)new Serializable(this, srcTable, limit){
                                        public static final long serialVersionUID = 0L;
                                        private final Table srcTable$1;
                                        private final PageLimit limit$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failure in fetching ", " data ", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.srcTable$1.name(), BoxesRunTime.boxToInteger((int)this.limit$1.pageIndex()), BoxesRunTime.boxToInteger((int)this.limit$1.pageSize())}));
                                        }
                                        {
                                            this.srcTable$1 = srcTable$1;
                                            this.limit$1 = limit$1;
                                        }
                                    });
                                    if (limit.pageIndex() * limit.pageSize() >= count.elem) {
                                        breakable = true;
                                    }
                                }
                                if (breakable) continue;
                                int successed = this.target().save(targetTable, data);
                                curr.elem += data.size();
                                ++pageIndex;
                                if (successed == count.elem) {
                                    this.org$beangle$db$conversion$converter$TableConverter$ConvertTask$$$outer().logger().info((Function0)new Serializable(this, targetTable, successed){
                                        public static final long serialVersionUID = 0L;
                                        private final Table targetTable$1;
                                        private final int successed$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Insert ", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTable$1, BoxesRunTime.boxToInteger((int)this.successed$1)}));
                                        }
                                        {
                                            this.targetTable$1 = targetTable$1;
                                            this.successed$1 = successed$1;
                                        }
                                    });
                                    continue;
                                }
                                if (successed == data.size()) {
                                    this.org$beangle$db$conversion$converter$TableConverter$ConvertTask$$$outer().logger().info((Function0)new Serializable(this, targetTable, count, curr){
                                        public static final long serialVersionUID = 0L;
                                        private final Table targetTable$1;
                                        private final IntRef count$1;
                                        private final IntRef curr$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Insert ", "(", "/", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTable$1, BoxesRunTime.boxToInteger((int)this.curr$1.elem), BoxesRunTime.boxToInteger((int)this.count$1.elem)}));
                                        }
                                        {
                                            this.targetTable$1 = targetTable$1;
                                            this.count$1 = count$1;
                                            this.curr$1 = curr$1;
                                        }
                                    });
                                    continue;
                                }
                                this.org$beangle$db$conversion$converter$TableConverter$ConvertTask$$$outer().logger().warn((Function0)new Serializable(this, targetTable, data, successed){
                                    public static final long serialVersionUID = 0L;
                                    private final Table targetTable$1;
                                    private final Seq data$1;
                                    private final int successed$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Insert ", "(", "/", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTable$1, BoxesRunTime.boxToInteger((int)this.successed$1), BoxesRunTime.boxToInteger((int)this.data$1.size())}));
                                    }
                                    {
                                        this.targetTable$1 = targetTable$1;
                                        this.data$1 = data$1;
                                        this.successed$1 = successed$1;
                                    }
                                });
                            }
                        }
                        break block10;
                    }
                    return;
                }
                catch (Exception exception) {
                    this.org$beangle$db$conversion$converter$TableConverter$ConvertTask$$$outer().logger().error((Function0)new Serializable(this, targetTable){
                        public static final long serialVersionUID = 0L;
                        private final Table targetTable$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Insert error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTable$1.qualifiedName()}));
                        }
                        {
                            this.targetTable$1 = targetTable$1;
                        }
                    }, (Function0)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$2;

                        public final Exception apply() {
                            return this.e$2;
                        }
                        {
                            this.e$2 = e$2;
                        }
                    });
                }
            }
        }

        public /* synthetic */ TableConverter org$beangle$db$conversion$converter$TableConverter$ConvertTask$$$outer() {
            return this.$outer;
        }

        public ConvertTask(TableConverter $outer, DataWrapper source, DataWrapper target, LinkedBlockingQueue<Tuple2<Table, Table>> buffer) {
            this.source = source;
            this.target = target;
            this.buffer = buffer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

