/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.db.conversion.converter;

import org.beangle.commons.lang.time.Stopwatch;
import org.beangle.commons.logging.Logger;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.dialect.Dialect;
import org.beangle.data.jdbc.meta.Sequence;
import org.beangle.db.conversion.Converter;
import org.beangle.db.conversion.SchemaWrapper;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u001b\t\t2+Z9vK:\u001cWmQ8om\u0016\u0014H/\u001a:\u000b\u0005\r!\u0011!C2p]Z,'\u000f^3s\u0015\t)a!\u0001\u0006d_:4XM]:j_:T!a\u0002\u0005\u0002\u0005\u0011\u0014'BA\u0005\u000b\u0003\u001d\u0011W-\u00198hY\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019!\u0002\u0004\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011\u0001B\u0005\u0003/\u0011\u0011\u0011bQ8om\u0016\u0014H/\u001a:\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012a\u00027pO\u001eLgn\u001a\u0006\u0003;!\tqaY8n[>t7/\u0003\u0002 5\t9Aj\\4hS:<\u0007\u0002C\u0011\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\rM|WO]2f+\u0005\u0019\u0003CA\u000b%\u0013\t)CAA\u0007TG\",W.Y,sCB\u0004XM\u001d\u0005\tO\u0001\u0011\t\u0011)A\u0005G\u000591o\\;sG\u0016\u0004\u0003\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\rQ\f'oZ3u\u0011!Y\u0003A!A!\u0002\u0013\u0019\u0013a\u0002;be\u001e,G\u000f\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\n$\u0007\u0005\u00021\u00015\t!\u0001C\u0003\"Y\u0001\u00071\u0005C\u0003*Y\u0001\u00071\u0005C\u00045\u0001\t\u0007I\u0011A\u001b\u0002\u0013M,\u0017/^3oG\u0016\u001cX#\u0001\u001c\u0011\u0007]bd(D\u00019\u0015\tI$(A\u0004nkR\f'\r\\3\u000b\u0005m\u0002\u0012AC2pY2,7\r^5p]&\u0011Q\b\u000f\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bCA G\u001b\u0005\u0001%BA!C\u0003\u0011iW\r^1\u000b\u0005\r#\u0015\u0001\u00026eE\u000eT!!\u0012\u0005\u0002\t\u0011\fG/Y\u0005\u0003\u000f\u0002\u0013\u0001bU3rk\u0016t7-\u001a\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002\u001c\u0002\u0015M,\u0017/^3oG\u0016\u001c\b\u0005C\u0003L\u0001\u0011\u0005A*A\u0003sKN,G\u000fF\u0001N!\tya*\u0003\u0002P!\t!QK\\5u\u0011\u0015\t\u0006\u0001\"\u0003S\u0003!\u0011Xm\u0011:fCR,GCA*W!\tyA+\u0003\u0002V!\t9!i\\8mK\u0006t\u0007\"B,Q\u0001\u0004q\u0014\u0001C:fcV,gnY3\t\u000be\u0003A\u0011\u0001'\u0002\u000bM$\u0018M\u001d;\t\u000bm\u0003A\u0011\u0001/\u0002\r\u0005$G-\u00117m)\tiU\fC\u0003_5\u0002\u0007q,\u0001\u0007oK^\u001cV-];f]\u000e,7\u000fE\u0002aCzj\u0011AO\u0005\u0003Ej\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a")
public class SequenceConverter
implements Converter,
Logging {
    private final SchemaWrapper source;
    private final SchemaWrapper target;
    private final ListBuffer<Sequence> sequences;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public SchemaWrapper source() {
        return this.source;
    }

    @Override
    public SchemaWrapper target() {
        return this.target;
    }

    public ListBuffer<Sequence> sequences() {
        return this.sequences;
    }

    @Override
    public void reset() {
    }

    public boolean org$beangle$db$conversion$converter$SequenceConverter$$reCreate(Sequence sequence) {
        if (this.target().drop(sequence)) {
            if (this.target().create(sequence)) {
                this.logger().info((Function0)new Serializable(this, sequence){
                    public static final long serialVersionUID = 0L;
                    private final Sequence sequence$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recreate sequence ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sequence$1.qualifiedName()}));
                    }
                    {
                        this.sequence$1 = sequence$1;
                    }
                });
                return true;
            }
            this.logger().error((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recreate sequence {sequence.qualifiedName} failure."})).s((Seq)Nil$.MODULE$);
                }
            });
        }
        return false;
    }

    @Override
    public void start() {
        Dialect targetDialect = this.target().dialect();
        if (targetDialect.sequenceGrammar() == null) {
            this.logger().info((Function0)new Serializable(this, targetDialect){
                public static final long serialVersionUID = 0L;
                private final Dialect targetDialect$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Target database ", " dosen't support sequence,replication ommited."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetDialect$1.getClass().getSimpleName()}));
                }
                {
                    this.targetDialect$1 = targetDialect$1;
                }
            });
            return;
        }
        Stopwatch watch = new Stopwatch(true);
        this.logger().info((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Start sequence replication...";
            }
        });
        ((TraversableForwarder)this.sequences().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceConverter $outer;

            public final boolean apply(Sequence sequence) {
                return this.$outer.org$beangle$db$conversion$converter$SequenceConverter$$reCreate(sequence);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.logger().info((Function0)new Serializable(this, watch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceConverter $outer;
            private final Stopwatch watch$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"End ", " sequence replication,using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.sequences().length()), this.watch$1}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.watch$1 = watch$1;
            }
        });
    }

    public void addAll(Iterable<Sequence> newSequences) {
        this.sequences().$plus$plus$eq(newSequences);
    }

    public SequenceConverter(SchemaWrapper source, SchemaWrapper target) {
        this.source = source;
        this.target = target;
        Logging.class.$init$((Logging)this);
        this.sequences = new ListBuffer();
    }
}

