/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.transfer.Format;
import org.beangle.data.transfer.Format$;
import org.beangle.data.transfer.exporter.ExportContext;
import org.beangle.data.transfer.io.ItemWriter;
import org.beangle.doc.excel.CellOps$;
import org.beangle.doc.excel.ExcelStyleRegistry;
import scala.Function1;
import scala.Predef$;
import scala.Short$;
import scala.collection.ArrayOps$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class ExcelItemWriter
implements ItemWriter {
    private final ExportContext context;
    private final OutputStream outputStream;
    private SXSSFWorkbook workbook;
    private SXSSFSheet sheet;
    private ExcelStyleRegistry registry;
    private Object title;
    private int flushCount;
    private int countPerSheet;
    private int index;

    public ExcelItemWriter(ExportContext context, OutputStream outputStream) {
        this.context = context;
        this.outputStream = outputStream;
        this.flushCount = 1000;
        this.countPerSheet = 100000;
        this.index = 0;
        this.init();
    }

    public ExportContext context() {
        return this.context;
    }

    public OutputStream outputStream() {
        return this.outputStream;
    }

    public Object title() {
        return this.title;
    }

    public void title_$eq(Object x$1) {
        this.title = x$1;
    }

    public int flushCount() {
        return this.flushCount;
    }

    public void flushCount_$eq(int x$1) {
        this.flushCount = x$1;
    }

    public int countPerSheet() {
        return this.countPerSheet;
    }

    public void countPerSheet_$eq(int x$1) {
        this.countPerSheet = x$1;
    }

    public void init() {
        int countParam;
        Object count;
        if (this.context() != null && (count = this.context().datas().getOrElse((Object)"countPerSheet", ExcelItemWriter::$anonfun$1)) != null && Numbers$.MODULE$.isDigits(count.toString()) && (countParam = Numbers$.MODULE$.toInt(count.toString(), Numbers$.MODULE$.toInt$default$2())) > 0) {
            this.countPerSheet_$eq(countParam);
        }
        this.workbook = new SXSSFWorkbook(this.flushCount());
        this.registry = new ExcelStyleRegistry((Workbook)this.workbook);
    }

    @Override
    public void close() {
        this.workbook.write(this.outputStream());
        this.workbook.dispose();
    }

    @Override
    public void write(Object obj) {
        if (this.index + 1 >= this.countPerSheet()) {
            this.writeTitle(null, this.title());
        }
        this.writeItem(obj);
        ++this.index;
    }

    @Override
    public void writeTitle(String titleName, Object data) {
        this.sheet = titleName != null ? this.workbook.createSheet(titleName) : this.workbook.createSheet();
        this.title_$eq(data);
        this.index = 0;
        this.writeItem(data);
        SXSSFRow titleRow = this.sheet.getRow(this.index);
        XSSFCellStyle titleStyle = this.buildTitleStyle();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), Short$.MODULE$.short2int(titleRow.getLastCellNum())).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> titleRow.getCell(i).setCellStyle((CellStyle)titleStyle));
        ++this.index;
        this.sheet.createFreezePane(0, 1);
    }

    @Override
    public Format format() {
        return Format$.Xlsx;
    }

    public void writeItem(Object datas) {
        SXSSFRow row = this.sheet.createRow(this.index);
        if (datas != null) {
            if (datas.getClass().isArray()) {
                Object values = datas;
                Object object = Predef$.MODULE$.genericArrayOps(values);
                ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> CellOps$.MODULE$.fillin$extension(CellOps$.MODULE$.toCell((Cell)row.createCell(i)), ScalaRunTime$.MODULE$.array_apply(values, i), this.registry));
            } else {
                SXSSFCell cell = row.createCell(0);
                Object object = datas;
                if (object instanceof Number) {
                    cell.setCellType(CellType.NUMERIC);
                }
                cell.setCellValue((RichTextString)new XSSFRichTextString(datas.toString()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public XSSFCellStyle buildTitleStyle() {
        void var1_1;
        XSSFCellStyle style = (XSSFCellStyle)this.workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        byte[] rgb = new byte[]{(byte)221, (byte)217, (byte)196};
        style.setFillForegroundColor(new XSSFColor(rgb, (IndexedColorMap)new DefaultIndexedColorMap()));
        return var1_1;
    }

    private static final String $anonfun$1() {
        return "";
    }
}

