/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.transfer.Format;
import org.beangle.data.transfer.Format$;
import org.beangle.data.transfer.excel.CellOps$;
import org.beangle.data.transfer.excel.ExcelItemReader$;
import org.beangle.data.transfer.io.Attribute;
import org.beangle.data.transfer.io.Attribute$;
import org.beangle.data.transfer.io.DataType;
import org.beangle.data.transfer.io.DataType$;
import org.beangle.data.transfer.io.ItemReader;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Short$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public class ExcelItemReader
implements ItemReader,
Logging {
    private Logger logger;
    private final Format format;
    private final Sheet sheet;
    private int indexInSheet;
    private List<Attribute> attrs;

    public static int $lessinit$greater$default$2() {
        return ExcelItemReader$.MODULE$.$lessinit$greater$default$2();
    }

    public static Format $lessinit$greater$default$3() {
        return ExcelItemReader$.MODULE$.$lessinit$greater$default$3();
    }

    public ExcelItemReader(InputStream is, int sheetNum, Format format) {
        this.format = format;
        Logging.$init$((Logging)this);
        this.sheet = this.buildSheet(is, sheetNum);
        this.indexInSheet = 1;
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    @Override
    public Format format() {
        return this.format;
    }

    private Sheet buildSheet(InputStream is, int sheetNum) {
        HSSFSheet hSSFSheet;
        Format format = this.format();
        Format format2 = Format$.Xls;
        Format format3 = format;
        if (!(format2 != null ? !format2.equals(format3) : format3 != null)) {
            hSSFSheet = new HSSFWorkbook(is).getSheetAt(sheetNum);
        } else {
            Format format4 = Format$.Xlsx;
            Format format5 = format;
            if (!(format4 != null ? !format4.equals(format5) : format5 != null)) {
                hSSFSheet = new XSSFWorkbook(is).getSheetAt(sheetNum);
            } else {
                throw new RuntimeException("Cannot support excel format " + this.format());
            }
        }
        return hSSFSheet;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Attribute> readAttributes() {
        void var2_2;
        int i;
        List<Attribute> attrs = package$.MODULE$.List().empty();
        for (i = 0; i < 10 && attrs.isEmpty(); ++i) {
            attrs = this.readAttributes(this.sheet, i);
        }
        this.indexInSheet = i;
        this.attrs = attrs;
        return var2_2;
    }

    public List<Attribute> readAttributes(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        ListBuffer attrList = new ListBuffer();
        BooleanRef hasEmptyCell = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), Short$.MODULE$.short2int(row.getLastCellNum())).withFilter((Function1)(JFunction1.mcZI.sp & Serializable)i -> !hasEmptyCell$1.elem).foreach((Function1 & Serializable)i -> ExcelItemReader.readAttributes$$anonfun$2(row, attrList, hasEmptyCell, BoxesRunTime.unboxToInt((Object)i)));
        return attrList.toList();
    }

    /*
     * WARNING - void declaration
     */
    public Object[] read() {
        Object[] objectArray;
        if (this.indexInSheet > this.sheet.getLastRowNum()) {
            return null;
        }
        Row row = this.sheet.getRow(this.indexInSheet);
        ++this.indexInSheet;
        int attrCount = this.attrs.size();
        if (row == null) {
            objectArray = new Object[attrCount];
        } else {
            void var3_3;
            Object[] values = new Object[attrCount];
            Object object = Predef$.MODULE$.genericArrayOps((Object)values);
            ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)(JFunction1.mcVI.sp & Serializable)k -> {
                values$1[k] = this.getCellValue(row.getCell(k), (Attribute)this.attrs.apply(k));
            });
            objectArray = var3_3;
        }
        return objectArray;
    }

    public Object getCellValue(Cell cell, Attribute attribute) {
        if (cell == null) {
            return null;
        }
        return CellOps$.MODULE$.getValue$extension(CellOps$.MODULE$.toCell(cell), attribute.dataType());
    }

    @Override
    public void close() {
        this.sheet.getWorkbook().close();
    }

    private static final /* synthetic */ Object readAttributes$$anonfun$2(Row row$1, ListBuffer attrList$1, BooleanRef hasEmptyCell$2, int i) {
        BoxedUnit boxedUnit;
        Cell cell = row$1.getCell(i);
        Comment comment = cell.getCellComment();
        if (comment == null || Strings$.MODULE$.isEmpty((CharSequence)comment.getString().getString())) {
            boolean bl;
            hasEmptyCell$2.elem = bl = true;
            boxedUnit = BoxedUnit.UNIT;
        } else {
            String commentStr = comment.getString().getString().trim();
            DataType dataType = DataType$.String;
            if (commentStr.indexOf(58) > 0) {
                dataType = DataType$.MODULE$.valueOf(Strings$.MODULE$.substringAfterLast(commentStr, ":"));
                commentStr = Strings$.MODULE$.substringBefore(commentStr, ":");
            }
            boxedUnit = attrList$1.$plus$eq((Object)Attribute$.MODULE$.apply(i + 1, commentStr.trim(), dataType, cell.getRichStringCellValue().getString()));
        }
        return boxedUnit;
    }
}

