/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.meta;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.xml.NodeOps$;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.engine.Engines$;
import org.beangle.data.jdbc.meta.Column;
import org.beangle.data.jdbc.meta.Database;
import org.beangle.data.jdbc.meta.ForeignKey;
import org.beangle.data.jdbc.meta.Schema;
import org.beangle.data.jdbc.meta.Serializer;
import org.beangle.data.jdbc.meta.Table;
import org.beangle.data.jdbc.meta.UniqueKey;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

public final class Serializer$
implements Serializable {
    public static final Serializer$ MODULE$ = new Serializer$();

    private Serializer$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Serializer$.class);
    }

    public Database fromXml(String content) {
        Elem root = (Elem)XML$.MODULE$.load((Reader)new StringReader(content));
        Engine engine = Engines$.MODULE$.forName(NodeOps$.MODULE$.attr$extension(NodeOps$.MODULE$.node2Ops((Node)root), "engine"));
        Database database = new Database(engine);
        database.version_$eq(NodeOps$.MODULE$.attr$extension(NodeOps$.MODULE$.node2Ops((Node)root), "version"));
        root.$bslash$bslash("schema").foreach((Function1)(JProcedure1 & Serializable)schemaElem -> {
            Schema schema = database.getOrCreateSchema(NodeOps$.MODULE$.name$extension(NodeOps$.MODULE$.node2Ops(schemaElem)));
            schemaElem.$bslash("tables").$bslash("table").foreach((Function1)(JProcedure1 & Serializable)tableElem -> {
                Table table = schema.createTable(NodeOps$.MODULE$.name$extension(NodeOps$.MODULE$.node2Ops(tableElem)));
                NodeOps$.MODULE$.get$extension(NodeOps$.MODULE$.node2Ops(tableElem), "comment").foreach((Function1)(JProcedure1 & Serializable)n -> table.updateCommentAndModule((String)n));
                tableElem.$bslash("columns").$bslash("column").foreach((Function1)(JProcedure1 & Serializable)colElem -> {
                    Column col = table.createColumn(NodeOps$.MODULE$.name$extension(NodeOps$.MODULE$.node2Ops(colElem)), NodeOps$.MODULE$.attr$extension(NodeOps$.MODULE$.node2Ops(colElem), "type"));
                    NodeOps$.MODULE$.get$extension(NodeOps$.MODULE$.node2Ops(colElem), "nullable").foreach((Function1)(JProcedure1 & Serializable)n -> col.nullable_$eq(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(n))));
                    NodeOps$.MODULE$.get$extension(NodeOps$.MODULE$.node2Ops(colElem), "unique").foreach((Function1)(JProcedure1 & Serializable)n -> col.unique_$eq(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(n))));
                    NodeOps$.MODULE$.get$extension(NodeOps$.MODULE$.node2Ops(colElem), "check").foreach((Function1)(JProcedure1 & Serializable)n -> col.check_$eq((Option<String>)Some$.MODULE$.apply(n)));
                    NodeOps$.MODULE$.get$extension(NodeOps$.MODULE$.node2Ops(colElem), "comment").foreach((Function1)(JProcedure1 & Serializable)n -> col.comment_$eq((Option)Some$.MODULE$.apply(n)));
                });
                tableElem.$bslash("primary-key").foreach((Function1 & Serializable)pkElem -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(NodeOps$.MODULE$.attr$extension(NodeOps$.MODULE$.node2Ops(pkElem), "columns")));
                    return table.createPrimaryKey(NodeOps$.MODULE$.name$extension(NodeOps$.MODULE$.node2Ops(pkElem)), (Seq<String>)ArrayOps$.MODULE$.toSeq$extension(object));
                });
                tableElem.$bslash("foreign-keys").$bslash("foreign-key").foreach((Function1)(JProcedure1 & Serializable)fkElem -> {
                    String name = NodeOps$.MODULE$.name$extension(NodeOps$.MODULE$.node2Ops(fkElem));
                    String column = NodeOps$.MODULE$.attr$extension(NodeOps$.MODULE$.node2Ops(fkElem), "column");
                    String referTable = NodeOps$.MODULE$.attr$extension(NodeOps$.MODULE$.node2Ops(fkElem), "referenced-table");
                    String referColumn = NodeOps$.MODULE$.attr$extension(NodeOps$.MODULE$.node2Ops(fkElem), "referenced-column");
                    ForeignKey fk = table.createForeignKey(name, column, database.refTable(referTable), referColumn);
                    NodeOps$.MODULE$.get$extension(NodeOps$.MODULE$.node2Ops(fkElem), "enabled").foreach((Function1)(JProcedure1 & Serializable)n -> fk.enabled_$eq(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(n))));
                    NodeOps$.MODULE$.get$extension(NodeOps$.MODULE$.node2Ops(fkElem), "cascadeDelete").foreach((Function1)(JProcedure1 & Serializable)n -> fk.cascadeDelete_$eq(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(n))));
                });
                tableElem.$bslash("unique-keys").$bslash("unique-key").foreach((Function1)(JProcedure1 & Serializable)ukElem -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(NodeOps$.MODULE$.attr$extension(NodeOps$.MODULE$.node2Ops(ukElem), "columns")));
                    UniqueKey uk = table.createUniqueKey(NodeOps$.MODULE$.name$extension(NodeOps$.MODULE$.node2Ops(ukElem)), (Seq<String>)ArrayOps$.MODULE$.toSeq$extension(object));
                    NodeOps$.MODULE$.get$extension(NodeOps$.MODULE$.node2Ops(ukElem), "enabled").foreach((Function1)(JProcedure1 & Serializable)n -> uk.enabled_$eq(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(n))));
                });
                tableElem.$bslash("indexes").$bslash("index").foreach((Function1 & Serializable)idxElem -> {
                    BooleanRef unique = BooleanRef.create((boolean)false);
                    NodeOps$.MODULE$.get$extension(NodeOps$.MODULE$.node2Ops(idxElem), "unique").foreach((Function1)(JProcedure1 & Serializable)n -> {
                        boolean bl;
                        unique$1.elem = bl = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(n));
                    });
                    Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(NodeOps$.MODULE$.attr$extension(NodeOps$.MODULE$.node2Ops(idxElem), "columns")));
                    return table.createIndex(NodeOps$.MODULE$.name$extension(NodeOps$.MODULE$.node2Ops(idxElem)), unique.elem, (Seq<String>)ArrayOps$.MODULE$.toSeq$extension(object));
                });
            });
        });
        return database;
    }

    public String toXml(Database database) {
        return new Serializer.Exporter(database).toXml();
    }
}

