/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.text.i18n;

import java.io.Serializable;
import java.util.Locale;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.text.i18n.DefaultTextResource;
import org.beangle.commons.text.i18n.TextBundleRegistry;
import org.beangle.commons.text.i18n.TextFormater;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Set;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class HierarchicalTextResource
extends DefaultTextResource {
    private final Class<?> clazz;

    public HierarchicalTextResource(Class<?> clazz, Locale locale, TextBundleRegistry registry, TextFormater formater) {
        this.clazz = clazz;
        super(locale, registry, formater);
    }

    private Locale locale$accessor() {
        return super.locale();
    }

    private TextBundleRegistry registry$accessor() {
        return super.registry();
    }

    private TextFormater formater$accessor() {
        return super.formater();
    }

    @Override
    public Option<String> get(String key) {
        String message = this.findMessage(this.clazz, key, (Set<String>)new HashSet());
        return message == null ? None$.MODULE$ : Some$.MODULE$.apply((Object)message);
    }

    public final String findMessage(Class<?> clazz, String key, Set<String> checked) {
        String string;
        Object object = new Object();
        try {
            String className = clazz.getName();
            if (checked.contains((Object)className)) {
                return null;
            }
            checked.add((Object)className);
            ObjectRef msg = ObjectRef.create((Object)this.getClassMessage(className, key));
            if ((String)msg.elem != null) {
                return (String)msg.elem;
            }
            String string2 = this.findPackageMessage(className, key, checked);
            msg.elem = string2;
            string2 = null;
            if ((String)msg.elem != null) {
                return (String)msg.elem;
            }
            HashSet interfaces = new HashSet();
            this.collectInterfaces(clazz, (Set<Class<?>>)interfaces);
            interfaces.foreach((Function1)(JProcedure1 & Serializable)ifc -> {
                String string = this.getClassMessage(ifc.getName(), key);
                msg$1.elem = string;
                string = null;
                if ((String)msg$1.elem != null) {
                    throw new NonLocalReturnControl(object, (Object)((String)msg$1.elem));
                }
            });
            interfaces.foreach((Function1)(JProcedure1 & Serializable)ifc -> {
                String string = this.findPackageMessage(ifc.getName(), key, checked);
                msg$2.elem = string;
                string = null;
                if ((String)msg$2.elem != null) {
                    throw new NonLocalReturnControl(object, (Object)((String)msg$2.elem));
                }
            });
            if (clazz.isInterface()) {
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])clazz.getInterfaces());
                ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)ifc -> {
                    String string = this.findMessage((Class<?>)ifc, key, checked);
                    msg$3.elem = string;
                    string = null;
                    if ((String)msg$3.elem != null) {
                        throw new NonLocalReturnControl(object, (Object)((String)msg$3.elem));
                    }
                });
            } else {
                Class<?> superClass = clazz.getSuperclass();
                if (!superClass.equals(Object.class) && !clazz.isPrimitive()) {
                    String string3 = this.findMessage(superClass, key, checked);
                    msg.elem = string3;
                    string3 = null;
                    if ((String)msg.elem != null) {
                        return (String)msg.elem;
                    }
                }
            }
            string = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                string = (String)ex.value();
            }
            throw ex;
        }
        return string;
    }

    private void collectInterfaces(Class<?> me, Set<Class<?>> interfaces) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])me.getInterfaces());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)ifc -> {
            if (!ifc.getName().startsWith("java.") && !ifc.getName().startsWith("scala.")) {
                interfaces.add(ifc);
            }
            this.collectInterfaces((Class<?>)ifc, interfaces);
        });
    }

    public final String findPackageMessage(String className, String key, Set<String> checkedSet) {
        String msg = null;
        String packageName = className;
        boolean checked = false;
        while (packageName.lastIndexOf(46) != -1 && !checked) {
            if (checkedSet.contains((Object)(packageName = Strings$.MODULE$.substringBeforeLast(packageName, ".")))) {
                checked = true;
                continue;
            }
            checkedSet.add((Object)packageName);
            msg = this.getPackageMessage(packageName, key);
            if (msg == null) continue;
            return msg;
        }
        return null;
    }

    public final String getPackageMessage(String packageName, String key) {
        return (String)this.registry$accessor().load(this.locale$accessor(), packageName + ".package").get(key).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public final String getClassMessage(String className, String key) {
        return (String)this.registry$accessor().load(this.locale$accessor(), className).get(key).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }
}

