/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.utils.misc;

import com.google.common.io.Resources;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.bdgenomics.utils.misc.SparkFunSuite;
import org.bdgenomics.utils.misc.SparkTest$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Assertions;
import org.scalatest.FunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

public abstract class SparkFunSuite$class {
    private static int nextTestPort(SparkFunSuite $this) {
        return $this.testPortRange().start() + $this.rnd().nextInt($this.testPortRange().length());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setupSparkContext(SparkFunSuite $this, String sparkName) {
        None$ maybeSc = None$.MODULE$;
        while (true) {
            if (!maybeSc.isEmpty()) {
                $this.sc_$eq((SparkContext)maybeSc.get());
                return;
            }
            SparkConf conf = new SparkConf(false).setAppName(new StringBuilder().append((Object)$this.appName()).append((Object)": ").append((Object)sparkName).toString()).setMaster($this.master()).set("spark.driver.port", ((Object)BoxesRunTime.boxToInteger((int)SparkFunSuite$class.nextTestPort($this))).toString()).set("spark.ui.enabled", "false").set("spark.driver.allowMultipleContexts", "true");
            $this.properties().foreach((Function1)new Serializable($this, conf){
                public static final long serialVersionUID = 0L;
                private final SparkConf conf$1;

                public final SparkConf apply(Tuple2<String, String> kv) {
                    return this.conf$1.set((String)kv._1(), (String)kv._2());
                }
                {
                    this.conf$1 = conf$1;
                }
            });
            maybeSc = new Some((Object)new SparkContext(conf));
        }
    }

    public static void teardownSparkContext(SparkFunSuite $this) {
        $this.sc().stop();
        $this.sc_$eq(null);
    }

    public static void sparkBefore(SparkFunSuite $this, String beforeName, Function0 body) {
        $this.before((Function0)new Serializable($this, beforeName, body){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkFunSuite $outer;
            private final String beforeName$1;
            private final Function0 body$1;

            public final Object apply() {
                this.$outer.setupSparkContext(this.beforeName$1);
                try {
                    this.body$1.apply$mcV$sp();
                    return BoxedUnit.UNIT;
                }
                finally {
                    this.$outer.teardownSparkContext();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.beforeName$1 = beforeName$1;
                this.body$1 = body$1;
            }
        });
    }

    public static void sparkAfter(SparkFunSuite $this, String beforeName, Function0 body) {
        $this.after((Function0)new Serializable($this, beforeName, body){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkFunSuite $outer;
            private final String beforeName$2;
            private final Function0 body$2;

            public final Object apply() {
                this.$outer.setupSparkContext(this.beforeName$2);
                try {
                    this.body$2.apply$mcV$sp();
                    return BoxedUnit.UNIT;
                }
                finally {
                    this.$outer.teardownSparkContext();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.beforeName$2 = beforeName$2;
                this.body$2 = body$2;
            }
        });
    }

    public static void sparkTest(SparkFunSuite $this, String name, Seq tags, Function0 body) {
        SparkTest$ sparkTest$ = SparkTest$.MODULE$;
        ((FunSuiteLike)$this).test(name, (Seq)tags.$plus$colon((Object)sparkTest$, Seq$.MODULE$.canBuildFrom()), (Function0)new Serializable($this, name, body){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkFunSuite $outer;
            private final String name$1;
            private final Function0 body$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.setupSparkContext(this.name$1);
                try {
                    this.body$3.apply$mcV$sp();
                    return;
                }
                finally {
                    this.$outer.teardownSparkContext();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$1 = name$1;
                this.body$3 = body$3;
            }
        });
    }

    public static String testFile(SparkFunSuite $this, String name) {
        URL url = $this.resourceUrl(name);
        if (url == null) {
            Predef$ predef$ = Predef$.MODULE$;
            throw new IllegalArgumentException(new StringOps("Couldn't find resource \"%s\"").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        return url.getFile();
    }

    public static URL resourceUrl(SparkFunSuite $this, String path) {
        return ClassLoader.getSystemClassLoader().getResource(path);
    }

    public static String tmpFile(SparkFunSuite $this, String path) {
        return new StringBuilder().append((Object)((Object)Files.createTempDirectory("", new FileAttribute[0]).toAbsolutePath()).toString()).append((Object)"/").append((Object)path).toString();
    }

    public static String tmpLocation(SparkFunSuite $this, String suffix) {
        File tempFile = File.createTempFile("TempSuite", "");
        File tempDir = tempFile.getParentFile();
        return new File(tempDir, new StringBuilder().append((Object)tempFile.getName()).append((Object)suffix).toString()).getAbsolutePath();
    }

    public static String tmpLocation$default$1(SparkFunSuite $this) {
        return ".adam";
    }

    public static void checkFiles(SparkFunSuite $this, String expectedPath, String actualPath) {
        BufferedSource actualFile = Source$.MODULE$.fromFile(actualPath, Codec$.MODULE$.fallbackSystemCodec());
        List actualLines = actualFile.getLines().toList();
        BufferedSource expectedFile = Source$.MODULE$.fromFile(expectedPath, Codec$.MODULE$.fallbackSystemCodec());
        List expectedLines = expectedFile.getLines().toList();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)BoxesRunTime.boxToInteger((int)expectedLines.size()));
        int $org_scalatest_assert_macro_right = actualLines.size();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        List list = (List)((IterableLike)expectedLines.zip((GenIterable)actualLines, List$.MODULE$.canBuildFrom())).zipWithIndex(List$.MODULE$.canBuildFrom());
        while (!list.isEmpty()) {
            Tuple2 tuple2 = (Tuple2)list.head();
            if (tuple2 != null && tuple2._1() != null) {
                String $org_scalatest_assert_macro_left1 = (String)((Tuple2)tuple2._1())._1();
                String $org_scalatest_assert_macro_right1 = (String)((Tuple2)tuple2._1())._2();
                String string = $org_scalatest_assert_macro_left1;
                Bool $org_scalatest_assert_macro_expr1 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left1, "==", (Object)$org_scalatest_assert_macro_right1, !(string != null ? !string.equals($org_scalatest_assert_macro_right1) : $org_scalatest_assert_macro_right1 != null));
                ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr1, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Line ", " differs.\\nExpected:\\n", "\\n\\nActual:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(tuple2._2$mcI$sp() + 1)), expectedLines.mkString("\n"), actualLines.mkString("\n")})));
                list = (List)list.tail();
                continue;
            }
            throw new MatchError((Object)tuple2);
        }
    }

    public static Path copyResourcePath(SparkFunSuite $this, String name) {
        Predef$ predef$ = Predef$.MODULE$;
        Path tempFile = Files.createTempFile(name, new StringBuilder().append((Object)".").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(name).split('.')).tail()).mkString(".")).toString(), new FileAttribute[0]);
        return Files.write(tempFile, Resources.toByteArray((URL)$this.getClass().getResource(new StringBuilder().append((Object)"/").append((Object)name).toString())), new OpenOption[0]);
    }

    public static String copyResource(SparkFunSuite $this, String name) {
        return ((Object)$this.copyResourcePath(name)).toString();
    }

    public static URI copyResourceUri(SparkFunSuite $this, String name) {
        return $this.copyResourcePath(name).toUri();
    }

    public static void $init$(SparkFunSuite $this) {
        $this.org$bdgenomics$utils$misc$SparkFunSuite$_setter_$appName_$eq("bdg-utils");
        $this.org$bdgenomics$utils$misc$SparkFunSuite$_setter_$master_$eq("local[4]");
        $this.org$bdgenomics$utils$misc$SparkFunSuite$_setter_$properties_$eq((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        Predef$ predef$ = Predef$.MODULE$;
        $this.org$bdgenomics$utils$misc$SparkFunSuite$_setter_$testPortRange_$eq(RichInt$.MODULE$.until$extension0(50000, 60000));
        $this.org$bdgenomics$utils$misc$SparkFunSuite$_setter_$rnd_$eq(new Random());
    }
}

