/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.mojo;

import com.google.common.base.Joiner;
import org.apache.maven.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

public final class InlineDependency {
    private String artifactId = null;
    private String groupId = null;
    private boolean hideClasses = false;
    private boolean transitive = false;

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean isHideClasses() {
        return this.hideClasses;
    }

    public InlineDependency setHideClasses(boolean hideClasses) {
        this.hideClasses = hideClasses;
        return this;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public InlineDependency setTransitive(boolean transitive) {
        this.transitive = transitive;
        return this;
    }

    public boolean matchDependency(Dependency dependency) {
        return this.getArtifactId().equals(dependency.getArtifact().getArtifactId()) && this.getGroupId().equals(dependency.getArtifact().getGroupId());
    }

    public boolean matchArtifact(Artifact artifact) {
        return this.getArtifactId().equals(artifact.getArtifactId()) && this.getGroupId().equals(artifact.getGroupId());
    }

    public String toString() {
        String flags = Joiner.on((String)", ").skipNulls().join((Object)(this.hideClasses ? "hide classes" : null), (Object)(this.transitive ? "inline transitive" : null), new Object[0]);
        return String.format("%s:%s [%s]", this.groupId, this.artifactId, flags);
    }
}

