/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.matchers;

import java.util.List;
import java.util.function.Predicate;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.test.matchers.EmptyCollectionMatcher;
import org.axonframework.test.matchers.EqualFieldsMatcher;
import org.axonframework.test.matchers.ExactSequenceMatcher;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.ListWithAllOfMatcher;
import org.axonframework.test.matchers.ListWithAnyOfMatcher;
import org.axonframework.test.matchers.NullOrVoidMatcher;
import org.axonframework.test.matchers.PayloadMatcher;
import org.axonframework.test.matchers.PayloadsMatcher;
import org.axonframework.test.matchers.PredicateMatcher;
import org.axonframework.test.matchers.SequenceMatcher;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public abstract class Matchers {
    public static Matcher<List<Message<?>>> payloadsMatching(Matcher<? extends List<?>> matcher) {
        return new PayloadsMatcher(matcher);
    }

    public static Matcher<Message<?>> messageWithPayload(Matcher<?> payloadMatcher) {
        return new PayloadMatcher(payloadMatcher);
    }

    @SafeVarargs
    @Factory
    public static <T> Matcher<List<T>> listWithAllOf(Matcher<T> ... matchers) {
        return new ListWithAllOfMatcher<T>(matchers);
    }

    @SafeVarargs
    @Factory
    public static <T> Matcher<List<T>> listWithAnyOf(Matcher<T> ... matchers) {
        return new ListWithAnyOfMatcher<T>(matchers);
    }

    @SafeVarargs
    @Factory
    public static <T> Matcher<List<T>> sequenceOf(Matcher<T> ... matchers) {
        return new SequenceMatcher<T>(matchers);
    }

    @SafeVarargs
    @Factory
    public static <T> Matcher<List<T>> exactSequenceOf(Matcher<? super T> ... matchers) {
        return new ExactSequenceMatcher<T>(matchers);
    }

    public static <T> Matcher<T> matches(Predicate<T> predicate) {
        return Matchers.predicate(predicate);
    }

    public static <T> Matcher<T> predicate(Predicate<T> predicate) {
        return new PredicateMatcher<T>(predicate);
    }

    @Factory
    public static Matcher<List<EventMessage<?>>> noEvents() {
        return new EmptyCollectionMatcher("events");
    }

    @Factory
    public static Matcher<List<CommandMessage<?>>> noCommands() {
        return new EmptyCollectionMatcher("commands");
    }

    @Factory
    public static <T> EqualFieldsMatcher<T> equalTo(T expected) {
        return new EqualFieldsMatcher<T>(expected);
    }

    @Factory
    public static <T> EqualFieldsMatcher<T> equalTo(T expected, FieldFilter filter) {
        return new EqualFieldsMatcher<T>(expected, filter);
    }

    @Factory
    public static Matcher<Message<?>> andNoMore() {
        return Matchers.nothing();
    }

    @Factory
    public static Matcher<Message<?>> nothing() {
        return new NullOrVoidMatcher();
    }

    private Matchers() {
    }
}

