/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.eventscheduler;

import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.GenericEventMessage;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.test.eventscheduler.ScheduledItem;
import org.axonframework.test.eventscheduler.StubScheduleToken;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class StubEventScheduler
implements EventScheduler {
    private final NavigableSet<StubScheduleToken> scheduledEvents = new TreeSet<StubScheduleToken>();
    private final AtomicInteger counter = new AtomicInteger(0);
    private DateTime currentDateTime;

    public StubEventScheduler() {
        this(null);
    }

    public StubEventScheduler(ReadableInstant currentDateTime) {
        this.currentDateTime = new DateTime((Object)currentDateTime);
    }

    public ScheduleToken schedule(DateTime triggerDateTime, Object event) {
        EventMessage eventMessage = GenericEventMessage.asEventMessage((Object)event);
        StubScheduleToken token = new StubScheduleToken(triggerDateTime, eventMessage, this.counter.getAndIncrement());
        this.scheduledEvents.add(token);
        return token;
    }

    public ScheduleToken schedule(Duration triggerDuration, Object event) {
        EventMessage eventMessage = GenericEventMessage.asEventMessage((Object)event);
        DateTime scheduleTime = this.currentDateTime.plus((ReadableDuration)triggerDuration);
        StubScheduleToken token = new StubScheduleToken(scheduleTime, eventMessage, this.counter.getAndIncrement());
        this.scheduledEvents.add(token);
        return token;
    }

    public void cancelSchedule(ScheduleToken scheduleToken) {
        if (!(scheduleToken instanceof StubScheduleToken)) {
            throw new IllegalArgumentException("Wrong token type. This token was not provided by this scheduler");
        }
        this.scheduledEvents.remove(scheduleToken);
    }

    public List<ScheduledItem> getScheduledItems() {
        return new ArrayList<ScheduledItem>(this.scheduledEvents);
    }

    public DateTime getCurrentDateTime() {
        return this.currentDateTime;
    }

    public EventMessage advanceToNextTrigger() {
        if (this.scheduledEvents.isEmpty()) {
            throw new NoSuchElementException("There are no scheduled events");
        }
        StubScheduleToken nextItem = this.scheduledEvents.pollFirst();
        if (nextItem.getScheduleTime().isAfter((ReadableInstant)this.currentDateTime)) {
            this.currentDateTime = nextItem.getScheduleTime();
        }
        return nextItem.getEvent();
    }

    public List<EventMessage> advanceTime(DateTime newDateTime) {
        ArrayList<EventMessage> triggeredEvents = new ArrayList<EventMessage>();
        while (!this.scheduledEvents.isEmpty() && !((StubScheduleToken)this.scheduledEvents.first()).getScheduleTime().isAfter((ReadableInstant)newDateTime)) {
            triggeredEvents.add(this.advanceToNextTrigger());
        }
        if (newDateTime.isAfter((ReadableInstant)this.currentDateTime)) {
            this.currentDateTime = newDateTime;
        }
        return triggeredEvents;
    }

    public List<EventMessage> advanceTime(Duration duration) {
        return this.advanceTime(this.currentDateTime.plus((ReadableDuration)duration));
    }
}

