/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import org.axonframework.eventhandling.EventBus;
import org.axonframework.saga.annotation.AbstractAnnotatedSaga;
import org.axonframework.saga.repository.inmemory.InMemorySagaRepository;
import org.axonframework.test.eventscheduler.StubEventScheduler;
import org.axonframework.test.matchers.Matchers;
import org.axonframework.test.saga.CommandValidator;
import org.axonframework.test.saga.EventSchedulerValidator;
import org.axonframework.test.saga.EventValidator;
import org.axonframework.test.saga.FixtureExecutionResult;
import org.axonframework.test.saga.RepositoryContentValidator;
import org.axonframework.test.utils.RecordingCommandBus;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class FixtureExecutionResultImpl
implements FixtureExecutionResult {
    private final RepositoryContentValidator repositoryContentValidator;
    private final EventValidator eventValidator;
    private final EventSchedulerValidator eventSchedulerValidator;
    private CommandValidator commandValidator;

    FixtureExecutionResultImpl(InMemorySagaRepository sagaRepository, StubEventScheduler eventScheduler, EventBus eventBus, RecordingCommandBus commandBus, Class<? extends AbstractAnnotatedSaga> sagaType) {
        this.commandValidator = new CommandValidator(commandBus);
        this.repositoryContentValidator = new RepositoryContentValidator(sagaRepository, sagaType);
        this.eventValidator = new EventValidator(eventBus);
        this.eventSchedulerValidator = new EventSchedulerValidator(eventScheduler);
    }

    public void startRecording() {
        this.eventValidator.startRecording();
        this.commandValidator.startRecording();
    }

    @Override
    public FixtureExecutionResult expectActiveSagas(int expected) {
        this.repositoryContentValidator.assertActiveSagas(expected);
        return this;
    }

    @Override
    public FixtureExecutionResult expectAssociationWith(String associationKey, Object associationValue) {
        this.repositoryContentValidator.assertAssociationPresent(associationKey, associationValue.toString());
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoAssociationWith(String associationKey, Object associationValue) {
        this.repositoryContentValidator.assertNoAssociationPresent(associationKey, associationValue.toString());
        return this;
    }

    @Override
    public FixtureExecutionResult expectScheduledEventMatching(Duration duration, Matcher<?> matcher) {
        this.eventSchedulerValidator.assertScheduledEventMatching(duration, matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectScheduledEvent(Duration duration, Object applicationEvent) {
        return this.expectScheduledEventMatching(duration, Matchers.messageWithPayload(Matchers.equalTo(applicationEvent)));
    }

    @Override
    public FixtureExecutionResult expectScheduledEventOfType(Duration duration, Class<?> eventType) {
        return this.expectScheduledEventMatching(duration, Matchers.messageWithPayload(CoreMatchers.any(eventType)));
    }

    @Override
    public FixtureExecutionResult expectScheduledEventMatching(DateTime scheduledTime, Matcher<?> matcher) {
        this.eventSchedulerValidator.assertScheduledEventMatching(scheduledTime, matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectScheduledEvent(DateTime scheduledTime, Object applicationEvent) {
        return this.expectScheduledEventMatching(scheduledTime, Matchers.messageWithPayload(Matchers.equalTo(applicationEvent)));
    }

    @Override
    public FixtureExecutionResult expectScheduledEventOfType(DateTime scheduledTime, Class<?> eventType) {
        return this.expectScheduledEventMatching(scheduledTime, Matchers.messageWithPayload(CoreMatchers.any(eventType)));
    }

    @Override
    public FixtureExecutionResult expectDispatchedCommandsEqualTo(Object ... expected) {
        this.commandValidator.assertDispatchedEqualTo(expected);
        return this;
    }

    @Override
    public FixtureExecutionResult expectDispatchedCommandsMatching(Matcher<? extends Iterable<?>> matcher) {
        this.commandValidator.assertDispatchedMatching(matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoDispatchedCommands() {
        this.commandValidator.assertDispatchedMatching(Matchers.noCommands());
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoScheduledEvents() {
        this.eventSchedulerValidator.assertNoScheduledEvents();
        return this;
    }

    @Override
    public FixtureExecutionResult expectPublishedEventsMatching(Matcher<? extends Iterable<?>> matcher) {
        this.eventValidator.assertPublishedEventsMatching(matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectPublishedEvents(Object ... expected) {
        this.eventValidator.assertPublishedEvents(expected);
        return this;
    }
}

