/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventsourcing;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.axonframework.config.Configuration;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.AbstractAggregateFactory;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.IncompatibleAggregateException;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringPrototypeAggregateFactory<T>
implements AggregateFactory<T>,
InitializingBean,
ApplicationContextAware,
BeanNameAware {
    private final String prototypeBeanName;
    private final Map<Class<? extends T>, String> subtypes;
    private ApplicationContext applicationContext;
    private String beanName;
    private Class<T> aggregateType;
    private AggregateFactory<T> delegate;

    public SpringPrototypeAggregateFactory(String prototypeBeanName) {
        this(prototypeBeanName, new HashMap<Class<? extends T>, String>());
    }

    public SpringPrototypeAggregateFactory(String prototypeBeanName, Map<Class<? extends T>, String> subtypes) {
        this.prototypeBeanName = prototypeBeanName;
        this.subtypes = subtypes;
    }

    public static <T> SpringPrototypeAggregateFactory<T> withSubtypeSupport(String prototypeBeanName, Map<Class<? extends T>, String> subtypes) {
        return new SpringPrototypeAggregateFactory<T>(prototypeBeanName, subtypes);
    }

    public T createAggregateRoot(String aggregateIdentifier, DomainEventMessage<?> firstEvent) {
        return (T)this.delegate.createAggregateRoot(aggregateIdentifier, firstEvent);
    }

    public Class<T> getAggregateType() {
        if (this.aggregateType == null) {
            this.aggregateType = this.applicationContext.getType(this.prototypeBeanName);
        }
        return this.aggregateType;
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.subtypes.put(this.getAggregateType(), this.prototypeBeanName);
    }

    public void setBeanName(@Nonnull String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() {
        AggregateModel model;
        if (!this.applicationContext.isPrototype(this.prototypeBeanName)) {
            throw new IncompatibleAggregateException(String.format("Cannot initialize repository '%s'. The bean with name '%s' does not have the 'prototype' scope.", this.beanName, this.prototypeBeanName));
        }
        if (this.applicationContext.getBeanNamesForType(Configuration.class).length > 0) {
            Configuration configuration = (Configuration)this.applicationContext.getBean(Configuration.class);
            model = AnnotatedAggregateMetaModelFactory.inspectAggregate(this.getAggregateType(), (ParameterResolverFactory)configuration.parameterResolverFactory(), (HandlerDefinition)configuration.handlerDefinition(this.getAggregateType()), this.subtypes.keySet());
        } else {
            model = AnnotatedAggregateMetaModelFactory.inspectAggregate(this.getAggregateType(), this.subtypes.keySet());
        }
        this.delegate = new AbstractAggregateFactory<T>(model){

            protected T doCreateAggregate(String aggregateIdentifier, DomainEventMessage firstEvent) {
                return SpringPrototypeAggregateFactory.this.applicationContext.getBean(this.prototype(firstEvent.getType()));
            }

            private String prototype(String aggregateType) {
                return this.aggregateModel().type(aggregateType).map(SpringPrototypeAggregateFactory.this.subtypes::get).orElse(SpringPrototypeAggregateFactory.this.prototypeBeanName);
            }

            protected T postProcessInstance(T aggregate) {
                SpringPrototypeAggregateFactory.this.applicationContext.getAutowireCapableBeanFactory().configureBean(aggregate, (String)SpringPrototypeAggregateFactory.this.subtypes.get(aggregate.getClass()));
                return aggregate;
            }
        };
    }
}

