/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config.annotation;

import java.util.List;
import javax.annotation.Nonnull;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathHandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MultiHandlerDefinition;
import org.axonframework.messaging.annotation.MultiHandlerEnhancerDefinition;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;

public class HandlerDefinitionFactoryBean
implements FactoryBean<HandlerDefinition>,
BeanClassLoaderAware {
    private final List<HandlerDefinition> definitions;
    private final List<HandlerEnhancerDefinition> enhancerDefinitions;
    private ClassLoader beanClassLoader;

    public HandlerDefinitionFactoryBean(List<HandlerDefinition> definitions, List<HandlerEnhancerDefinition> enhancerDefinitions) {
        this.definitions = definitions;
        this.enhancerDefinitions = enhancerDefinitions;
    }

    public HandlerDefinition getObject() {
        return MultiHandlerDefinition.ordered((HandlerEnhancerDefinition)this.resolveEnhancers(), (HandlerDefinition[])new HandlerDefinition[]{this.resolveDefinitions()});
    }

    private MultiHandlerDefinition resolveDefinitions() {
        return MultiHandlerDefinition.ordered((HandlerDefinition[])new HandlerDefinition[]{ClasspathHandlerDefinition.forClassLoader((ClassLoader)this.beanClassLoader), MultiHandlerDefinition.ordered(this.definitions)});
    }

    private MultiHandlerEnhancerDefinition resolveEnhancers() {
        return MultiHandlerEnhancerDefinition.ordered((HandlerEnhancerDefinition[])new HandlerEnhancerDefinition[]{ClasspathHandlerEnhancerDefinition.forClassLoader((ClassLoader)this.beanClassLoader), MultiHandlerEnhancerDefinition.ordered(this.enhancerDefinitions)});
    }

    public Class<?> getObjectType() {
        return HandlerDefinition.class;
    }

    public void setBeanClassLoader(@Nonnull ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

