/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.ObjectUtils;

public class SpringUtils {
    private SpringUtils() {
    }

    public static boolean isQualifierMatch(String beanName, ConfigurableListableBeanFactory beanFactory, String qualifier) {
        if (!beanFactory.containsBean(beanName)) {
            return false;
        }
        try {
            Qualifier targetAnnotation;
            Method factoryMethod;
            AbstractBeanDefinition abd;
            AutowireCandidateQualifier candidate;
            MethodMetadata factoryMethodMetadata;
            Map qualifierAttributes;
            BeanDefinition bd = beanFactory.getMergedBeanDefinition(beanName);
            if (bd instanceof AnnotatedBeanDefinition && (qualifierAttributes = (factoryMethodMetadata = ((AnnotatedBeanDefinition)bd).getFactoryMethodMetadata()).getAnnotationAttributes(Qualifier.class.getName())) != null && qualifier.equals(qualifierAttributes.get("value"))) {
                return true;
            }
            if (bd instanceof AbstractBeanDefinition && ((candidate = (abd = (AbstractBeanDefinition)bd).getQualifier(Qualifier.class.getName())) != null && qualifier.equals(candidate.getAttribute("value")) || qualifier.equals(beanName) || ObjectUtils.containsElement((Object[])beanFactory.getAliases(beanName), (Object)qualifier))) {
                return true;
            }
            if (bd instanceof RootBeanDefinition && (factoryMethod = ((RootBeanDefinition)bd).getResolvedFactoryMethod()) != null && (targetAnnotation = (Qualifier)AnnotationUtils.getAnnotation((Method)factoryMethod, Qualifier.class)) != null) {
                return qualifier.equals(targetAnnotation.value());
            }
            Class beanType = beanFactory.getType(beanName);
            if (beanType != null && (targetAnnotation = (Qualifier)AnnotationUtils.getAnnotation((AnnotatedElement)beanType, Qualifier.class)) != null) {
                return qualifier.equals(targetAnnotation.value());
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return false;
    }
}

