/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config.annotation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MultiHandlerDefinition;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringHandlerDefinitionBean
implements FactoryBean<HandlerDefinition>,
BeanClassLoaderAware,
InitializingBean,
ApplicationContextAware {
    private final List<HandlerDefinition> definitions = new ArrayList<HandlerDefinition>();
    private ClassLoader classLoader;
    private ApplicationContext applicationContext;

    public SpringHandlerDefinitionBean() {
    }

    public SpringHandlerDefinitionBean(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.initialize();
    }

    public HandlerDefinition getObject() {
        return MultiHandlerDefinition.ordered(this.definitions);
    }

    public Class<?> getObjectType() {
        return HandlerDefinition.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() {
        this.initialize();
    }

    public void setAdditionalHandlers(List<HandlerDefinition> additionalFactories) {
        this.definitions.addAll(additionalFactories);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void initialize() {
        this.definitions.addAll(ClasspathHandlerDefinition.forClassLoader((ClassLoader)this.classLoader).getDelegates());
        Map definitionsFound = this.applicationContext.getBeansOfType(HandlerDefinition.class);
        this.definitions.addAll(definitionsFound.values());
    }
}

