/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.messaging;

import java.util.List;
import java.util.function.Predicate;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.spring.messaging.DefaultEventMessageConverter;
import org.axonframework.spring.messaging.EventMessageConverter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public class OutboundEventMessageChannelAdapter
implements InitializingBean {
    private final MessageChannel channel;
    private final Predicate<? super EventMessage<?>> filter;
    private final SubscribableMessageSource<EventMessage<?>> messageSource;
    private final EventMessageConverter eventMessageConverter;

    public OutboundEventMessageChannelAdapter(SubscribableMessageSource<EventMessage<?>> messageSource, MessageChannel channel) {
        this(messageSource, channel, m -> true);
    }

    public OutboundEventMessageChannelAdapter(SubscribableMessageSource<EventMessage<?>> messageSource, MessageChannel channel, Predicate<? super EventMessage<?>> filter) {
        this(messageSource, channel, filter, new DefaultEventMessageConverter());
    }

    public OutboundEventMessageChannelAdapter(SubscribableMessageSource<EventMessage<?>> messageSource, MessageChannel channel, Predicate<? super EventMessage<?>> filter, EventMessageConverter eventMessageConverter) {
        this.channel = channel;
        this.messageSource = messageSource;
        this.filter = filter;
        this.eventMessageConverter = eventMessageConverter;
    }

    public void afterPropertiesSet() {
        this.messageSource.subscribe(this::handle);
    }

    protected void handle(List<? extends EventMessage<?>> events) {
        events.stream().filter(this.filter::test).forEach(event -> this.channel.send(this.transform((EventMessage<?>)event)));
    }

    protected Message<?> transform(EventMessage<?> event) {
        return this.eventMessageConverter.convertToOutboundMessage(event);
    }
}

