/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.IdentifierMissingException;
import org.axonframework.modelling.command.VersionedAggregateIdentifier;

public class MetaDataCommandTargetResolver
implements CommandTargetResolver {
    private final String identifierKey;
    private final String versionKey;

    public MetaDataCommandTargetResolver(String identifierKey) {
        this(identifierKey, null);
    }

    public MetaDataCommandTargetResolver(String identifierKey, String versionKey) {
        this.versionKey = versionKey;
        this.identifierKey = identifierKey;
    }

    @Override
    public VersionedAggregateIdentifier resolveTarget(@Nonnull CommandMessage<?> command) {
        Object identifier = command.getMetaData().get((Object)this.identifierKey);
        if (identifier == null) {
            throw new IdentifierMissingException("The MetaData for the command does not contain an identifier under key [" + this.identifierKey + "]");
        }
        Long version = (Long)(this.versionKey == null ? null : command.getMetaData().get((Object)this.versionKey));
        return new VersionedAggregateIdentifier(identifier, version);
    }
}

