/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandMessageHandler;
import org.axonframework.commandhandling.CommandMessageHandlingMember;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.Registration;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateCreationPolicy;
import org.axonframework.modelling.command.AnnotationCommandTargetResolver;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.CreationPolicyAggregateFactory;
import org.axonframework.modelling.command.IdentifierMissingException;
import org.axonframework.modelling.command.NoArgumentConstructorCreationPolicyAggregateFactory;
import org.axonframework.modelling.command.Repository;
import org.axonframework.modelling.command.VersionedAggregateIdentifier;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;
import org.axonframework.modelling.command.inspection.CreationPolicyMember;

public class AggregateAnnotationCommandHandler<T>
implements CommandMessageHandler {
    private final Repository<T> repository;
    private final CommandTargetResolver commandTargetResolver;
    private final List<MessageHandler<CommandMessage<?>>> handlers;
    private final Set<String> supportedCommandNames;
    private final Map<String, Set<MessageHandler<CommandMessage<?>>>> supportedCommandsByName;
    private final CreationPolicyAggregateFactory<T> creationPolicyAggregateFactory;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    protected AggregateAnnotationCommandHandler(Builder<T> builder) {
        builder.validate();
        this.repository = ((Builder)builder).repository;
        this.commandTargetResolver = ((Builder)builder).commandTargetResolver;
        this.supportedCommandNames = new HashSet<String>();
        this.supportedCommandsByName = new HashMap();
        AggregateModel aggregateModel = ((Builder)builder).buildAggregateModel();
        this.creationPolicyAggregateFactory = this.initializeAggregateFactory(aggregateModel.entityClass(), ((Builder)builder).creationPolicyAggregateFactory);
        this.handlers = this.initializeHandlers(aggregateModel);
    }

    private CreationPolicyAggregateFactory<T> initializeAggregateFactory(Class<? extends T> aggregateClass, CreationPolicyAggregateFactory<T> configuredAggregateFactory) {
        return configuredAggregateFactory != null ? configuredAggregateFactory : new NoArgumentConstructorCreationPolicyAggregateFactory<T>(aggregateClass);
    }

    public Registration subscribe(CommandBus commandBus) {
        List subscriptions = this.supportedCommandsByName.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(messageHandler -> commandBus.subscribe((String)entry.getKey(), messageHandler))).filter(Objects::nonNull).collect(Collectors.toList());
        return () -> subscriptions.stream().map(Registration::cancel).reduce(Boolean::logicalOr).orElse(false);
    }

    private List<MessageHandler<CommandMessage<?>>> initializeHandlers(AggregateModel<T> aggregateModel) {
        ArrayList handlersFound = new ArrayList();
        aggregateModel.allCommandHandlers().values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(this::getHandlerSignature)).forEach((signature, commandHandlers) -> this.initializeHandler(aggregateModel, (MessageHandlingMember)commandHandlers.get(0), handlersFound));
        return handlersFound;
    }

    private String getHandlerSignature(MessageHandlingMember<? super T> handler) {
        return handler.unwrap(Executable.class).map(ReflectionUtils::toDiscernibleSignature).orElseThrow(() -> new IllegalStateException("A handler is missing an Executable. Please provide an Executable in your MessageHandlingMembers"));
    }

    private void initializeHandler(AggregateModel<T> aggregateModel, MessageHandlingMember<? super T> handler, List<MessageHandler<CommandMessage<?>>> handlersFound) {
        handler.unwrap(CommandMessageHandlingMember.class).ifPresent(cmh -> {
            Optional<AggregateCreationPolicy> policy = handler.unwrap(CreationPolicyMember.class).map(CreationPolicyMember::creationPolicy);
            Object messageHandler = null;
            if (cmh.isFactoryHandler()) {
                BuilderUtils.assertThat(policy, p -> p.map(AggregateCreationPolicy.ALWAYS::equals).orElse(true), (String)(aggregateModel.type() + ": Static methods/constructors can only use creationPolicy ALWAYS"));
                messageHandler = new AggregateConstructorCommandHandler(handler);
            } else {
                switch (policy.orElse(AggregateCreationPolicy.NEVER)) {
                    case ALWAYS: {
                        messageHandler = new AlwaysCreateAggregateCommandHandler(handler, this.creationPolicyAggregateFactory);
                        break;
                    }
                    case CREATE_IF_MISSING: {
                        messageHandler = new AggregateCreateOrUpdateCommandHandler(handler, this.creationPolicyAggregateFactory);
                        break;
                    }
                    case NEVER: {
                        messageHandler = new AggregateCommandHandler(handler);
                    }
                }
            }
            handlersFound.add((MessageHandler<CommandMessage<?>>)messageHandler);
            this.supportedCommandsByName.computeIfAbsent(cmh.commandName(), key -> new HashSet()).add(messageHandler);
            this.supportedCommandNames.add(cmh.commandName());
        });
    }

    public Object handle(CommandMessage<?> commandMessage) throws Exception {
        return this.handlers.stream().filter(ch -> ch.canHandle((Message)commandMessage)).findFirst().orElseThrow(() -> new NoHandlerForCommandException(commandMessage)).handle(commandMessage);
    }

    public boolean canHandle(CommandMessage<?> message) {
        return this.handlers.stream().anyMatch(ch -> ch.canHandle((Message)message));
    }

    protected Object resolveReturnValue(CommandMessage<?> command, Aggregate<T> createdAggregate) {
        return createdAggregate.identifier();
    }

    public Set<String> supportedCommandNames() {
        return this.supportedCommandNames;
    }

    private VersionedAggregateIdentifier resolveNullableAggregateId(CommandMessage<?> command) {
        try {
            return this.commandTargetResolver.resolveTarget(command);
        }
        catch (IdentifierMissingException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("It does not identify the target aggregate.")) {
                return null;
            }
            throw e;
        }
    }

    private Object handleNewInstanceCreation(CommandMessage<?> command, CreationPolicyAggregateFactory<T> factoryMethod, MessageHandlingMember<? super T> handler, VersionedAggregateIdentifier commandMessageVersionedId) throws Exception {
        AtomicReference response = new AtomicReference();
        AtomicReference exceptionDuringInit = new AtomicReference();
        Object commandMessageAggregateId = Optional.ofNullable(commandMessageVersionedId).map(VersionedAggregateIdentifier::getIdentifierValue).orElse(null);
        Aggregate<Object> aggregate = this.repository.newInstance(() -> factoryMethod.create(commandMessageAggregateId), a -> {
            try {
                response.set(a.handle((Message<?>)command));
            }
            catch (Exception e) {
                exceptionDuringInit.set(e);
            }
        });
        if (exceptionDuringInit.get() != null) {
            throw (Exception)exceptionDuringInit.get();
        }
        return AggregateAnnotationCommandHandler.handlerHasVoidReturnType(handler) ? this.resolveReturnValue(command, aggregate) : response.get();
    }

    private static <T> boolean handlerHasVoidReturnType(MessageHandlingMember<? super T> handler) {
        return handler.unwrap(Method.class).map(Method::getReturnType).filter(Void.TYPE::equals).isPresent();
    }

    private class AggregateCommandHandler
    implements MessageHandler<CommandMessage<?>> {
        private final MessageHandlingMember<? super T> handler;

        public AggregateCommandHandler(MessageHandlingMember<? super T> handler) {
            this.handler = handler;
        }

        public Object handle(CommandMessage<?> command) throws Exception {
            VersionedAggregateIdentifier iv = AggregateAnnotationCommandHandler.this.commandTargetResolver.resolveTarget(command);
            return AggregateAnnotationCommandHandler.this.repository.load(iv.getIdentifier(), iv.getVersion()).handle((Message<?>)command);
        }

        public boolean canHandle(CommandMessage<?> message) {
            return this.handler.canHandle(message);
        }
    }

    private class AggregateCreateOrUpdateCommandHandler
    implements MessageHandler<CommandMessage<?>> {
        private final MessageHandlingMember<? super T> handler;
        private final CreationPolicyAggregateFactory<T> factoryMethod;

        public AggregateCreateOrUpdateCommandHandler(MessageHandlingMember<? super T> handler, CreationPolicyAggregateFactory<T> factoryMethod) {
            this.handler = handler;
            this.factoryMethod = factoryMethod;
        }

        public Object handle(CommandMessage<?> command) throws Exception {
            Object result;
            VersionedAggregateIdentifier versionedAggregateIdentifier = AggregateAnnotationCommandHandler.this.resolveNullableAggregateId(command);
            if (versionedAggregateIdentifier != null) {
                Aggregate<Object> instance = AggregateAnnotationCommandHandler.this.repository.loadOrCreate(versionedAggregateIdentifier.getIdentifier(), () -> this.factoryMethod.create(versionedAggregateIdentifier.getIdentifierValue()));
                result = instance.handle((Message<?>)command);
            } else {
                result = AggregateAnnotationCommandHandler.this.handleNewInstanceCreation(command, this.factoryMethod, this.handler, AggregateAnnotationCommandHandler.this.resolveNullableAggregateId(command));
            }
            return result;
        }

        public boolean canHandle(CommandMessage<?> message) {
            return this.handler.canHandle(message);
        }
    }

    private class AlwaysCreateAggregateCommandHandler
    implements MessageHandler<CommandMessage<?>> {
        private final MessageHandlingMember<? super T> handler;
        private final CreationPolicyAggregateFactory<T> factoryMethod;

        private AlwaysCreateAggregateCommandHandler(MessageHandlingMember<? super T> handler, CreationPolicyAggregateFactory<T> factoryMethod) {
            this.handler = handler;
            this.factoryMethod = factoryMethod;
        }

        public Object handle(CommandMessage<?> command) throws Exception {
            return AggregateAnnotationCommandHandler.this.handleNewInstanceCreation(command, this.factoryMethod, this.handler, AggregateAnnotationCommandHandler.this.resolveNullableAggregateId(command));
        }

        public boolean canHandle(CommandMessage<?> message) {
            return this.handler.canHandle(message);
        }
    }

    private class AggregateConstructorCommandHandler
    implements MessageHandler<CommandMessage<?>> {
        private final MessageHandlingMember<?> handler;

        public AggregateConstructorCommandHandler(MessageHandlingMember<?> handler) {
            this.handler = handler;
        }

        public Object handle(CommandMessage<?> command) throws Exception {
            Aggregate<Object> aggregate = AggregateAnnotationCommandHandler.this.repository.newInstance(() -> this.handler.handle((Message)command, null));
            return AggregateAnnotationCommandHandler.this.resolveReturnValue(command, aggregate);
        }

        public boolean canHandle(CommandMessage<?> message) {
            return this.handler.canHandle(message);
        }
    }

    public static class Builder<T> {
        private Repository<T> repository;
        private CommandTargetResolver commandTargetResolver = AnnotationCommandTargetResolver.builder().build();
        private Class<T> aggregateType;
        private ParameterResolverFactory parameterResolverFactory;
        private HandlerDefinition handlerDefinition;
        private AggregateModel<T> aggregateModel;
        private CreationPolicyAggregateFactory<T> creationPolicyAggregateFactory;

        public Builder<T> repository(Repository<T> repository) {
            BuilderUtils.assertNonNull(repository, (String)"Repository may not be null");
            this.repository = repository;
            return this;
        }

        public Builder<T> commandTargetResolver(CommandTargetResolver commandTargetResolver) {
            BuilderUtils.assertNonNull((Object)commandTargetResolver, (String)"CommandTargetResolver may not be null");
            this.commandTargetResolver = commandTargetResolver;
            return this;
        }

        public Builder<T> aggregateType(Class<T> aggregateType) {
            BuilderUtils.assertNonNull(aggregateType, (String)"The aggregateType may not be null");
            this.aggregateType = aggregateType;
            return this;
        }

        public Builder<T> parameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
            BuilderUtils.assertNonNull((Object)parameterResolverFactory, (String)"ParameterResolverFactory may not be null");
            this.parameterResolverFactory = parameterResolverFactory;
            return this;
        }

        public Builder<T> handlerDefinition(HandlerDefinition handlerDefinition) {
            BuilderUtils.assertNonNull((Object)handlerDefinition, (String)"HandlerDefinition may not be null");
            this.handlerDefinition = handlerDefinition;
            return this;
        }

        public Builder<T> aggregateModel(AggregateModel<T> aggregateModel) {
            BuilderUtils.assertNonNull(aggregateModel, (String)"AggregateModel may not be null");
            this.aggregateModel = aggregateModel;
            return this;
        }

        public Builder<T> creationPolicyAggregateFactory(CreationPolicyAggregateFactory<T> creationPolicyAggregateFactory) {
            BuilderUtils.assertNonNull(creationPolicyAggregateFactory, (String)"CreationPolicyAggregateFactory may not be null");
            this.creationPolicyAggregateFactory = creationPolicyAggregateFactory;
            return this;
        }

        private AggregateModel<T> buildAggregateModel() {
            if (this.aggregateModel == null) {
                return this.inspectAggregateModel();
            }
            return this.aggregateModel;
        }

        private AggregateModel<T> inspectAggregateModel() {
            if (this.parameterResolverFactory == null) {
                this.parameterResolverFactory = ClasspathParameterResolverFactory.forClass(this.aggregateType);
            }
            return this.handlerDefinition == null ? AnnotatedAggregateMetaModelFactory.inspectAggregate(this.aggregateType, this.parameterResolverFactory) : AnnotatedAggregateMetaModelFactory.inspectAggregate(this.aggregateType, this.parameterResolverFactory, this.handlerDefinition);
        }

        public AggregateAnnotationCommandHandler<T> build() {
            return new AggregateAnnotationCommandHandler(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.repository, (String)"The Repository is a hard requirement and should be provided");
            if (this.aggregateModel == null) {
                BuilderUtils.assertNonNull(this.aggregateType, (String)"No AggregateModel is set, whilst either it or the aggregateType is a hard requirement");
                return;
            }
            BuilderUtils.assertNonNull(this.aggregateModel, (String)"No aggregateType is set, whilst either it or the AggregateModel is a hard requirement");
        }
    }
}

