/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.repository;

import java.util.function.Supplier;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.lock.Lock;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.common.lock.PessimisticLockFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.modelling.saga.Saga;
import org.axonframework.modelling.saga.SagaRepository;

public abstract class LockingSagaRepository<T>
implements SagaRepository<T> {
    private final LockFactory lockFactory;

    protected LockingSagaRepository(Builder<T> builder) {
        builder.validate();
        this.lockFactory = ((Builder)builder).lockFactory;
    }

    @Override
    public Saga<T> load(String sagaIdentifier) {
        this.lockSagaAccess(sagaIdentifier);
        return this.doLoad(sagaIdentifier);
    }

    @Override
    public Saga<T> createInstance(String sagaIdentifier, Supplier<T> factoryMethod) {
        this.lockSagaAccess(sagaIdentifier);
        return this.doCreateInstance(sagaIdentifier, factoryMethod);
    }

    private void lockSagaAccess(String sagaIdentifier) {
        UnitOfWork unitOfWork = CurrentUnitOfWork.get();
        Lock lock = this.lockFactory.obtainLock(sagaIdentifier);
        unitOfWork.root().onCleanup(u -> lock.release());
    }

    protected abstract Saga<T> doLoad(String var1);

    protected abstract Saga<T> doCreateInstance(String var1, Supplier<T> var2);

    public static abstract class Builder<T> {
        private LockFactory lockFactory = PessimisticLockFactory.usingDefaults();

        public Builder<T> lockFactory(LockFactory lockFactory) {
            BuilderUtils.assertNonNull((Object)lockFactory, (String)"LockFactory may not be null");
            this.lockFactory = lockFactory;
            return this;
        }

        protected void validate() throws AxonConfigurationException {
        }
    }
}

