/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.common.Assert;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.VersionedAggregateIdentifier;

public class MetaDataCommandTargetResolver
implements CommandTargetResolver {
    private final String identifierKey;
    private final String versionKey;

    public MetaDataCommandTargetResolver(String identifierKey) {
        this(identifierKey, null);
    }

    public MetaDataCommandTargetResolver(String identifierKey, String versionKey) {
        this.versionKey = versionKey;
        this.identifierKey = identifierKey;
    }

    @Override
    public VersionedAggregateIdentifier resolveTarget(CommandMessage<?> command) {
        String identifier = (String)command.getMetaData().get((Object)this.identifierKey);
        Assert.notNull((Object)identifier, () -> "The MetaData for the command does not exist or contains a null value");
        Long version = (Long)(this.versionKey == null ? null : command.getMetaData().get((Object)this.versionKey));
        return new VersionedAggregateIdentifier(identifier, version);
    }
}

