/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import java.util.Map;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.messaging.AbstractMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedObjectHolder;
import org.axonframework.serialization.Serializer;

public class GenericMessage<T>
extends AbstractMessage<T> {
    private static final long serialVersionUID = 7937214711724527316L;
    private final MetaData metaData;
    private final Class<T> payloadType;
    private final T payload;
    private volatile transient SerializedObjectHolder serializedObjectHolder;

    public GenericMessage(T payload) {
        this(payload, MetaData.emptyInstance());
    }

    public GenericMessage(T payload, Map<String, ?> metaData) {
        this(GenericMessage.getDeclaredPayloadType(payload), payload, metaData);
    }

    public GenericMessage(Class<T> declaredPayloadType, T payload, Map<String, ?> metaData) {
        this(IdentifierFactory.getInstance().generateIdentifier(), declaredPayloadType, payload, CurrentUnitOfWork.correlationData().mergedWith(MetaData.from(metaData)));
    }

    public GenericMessage(String identifier, T payload, Map<String, ?> metaData) {
        this(identifier, GenericMessage.getDeclaredPayloadType(payload), payload, metaData);
    }

    public GenericMessage(String identifier, Class<T> declaredPayloadType, T payload, Map<String, ?> metaData) {
        super(identifier);
        this.metaData = MetaData.from(metaData);
        this.payload = payload;
        this.payloadType = declaredPayloadType;
    }

    private GenericMessage(GenericMessage<T> original, MetaData metaData) {
        super(original.getIdentifier());
        this.payload = original.getPayload();
        this.payloadType = original.getPayloadType();
        this.metaData = metaData;
    }

    private static <T> Class<T> getDeclaredPayloadType(T payload) {
        return payload != null ? payload.getClass() : Void.class;
    }

    @Override
    public MetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public T getPayload() {
        return this.payload;
    }

    @Override
    public Class<T> getPayloadType() {
        return this.payloadType;
    }

    @Override
    protected Message<T> withMetaData(MetaData metaData) {
        return new GenericMessage<T>(this, metaData);
    }

    @Override
    public <R> SerializedObject<R> serializePayload(Serializer serializer, Class<R> expectedRepresentation) {
        return this.serializedObjectHolder().serializePayload(serializer, expectedRepresentation);
    }

    @Override
    public <R> SerializedObject<R> serializeMetaData(Serializer serializer, Class<R> expectedRepresentation) {
        return this.serializedObjectHolder().serializeMetaData(serializer, expectedRepresentation);
    }

    private SerializedObjectHolder serializedObjectHolder() {
        if (this.serializedObjectHolder == null) {
            this.serializedObjectHolder = new SerializedObjectHolder(this);
        }
        return this.serializedObjectHolder;
    }
}

