/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore;

import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventhandling.tokenstore.UnableToInitializeTokenException;

public interface TokenStore {
    default public void initializeTokenSegments(String processorName, int segmentCount) throws UnableToClaimTokenException {
        for (int segment = 0; segment < segmentCount; ++segment) {
            this.fetchToken(processorName, segment);
            this.releaseClaim(processorName, segment);
        }
    }

    default public void initializeTokenSegments(String processorName, int segmentCount, TrackingToken initialToken) throws UnableToClaimTokenException {
        for (int segment = 0; segment < segmentCount; ++segment) {
            this.storeToken(initialToken, processorName, segment);
            this.releaseClaim(processorName, segment);
        }
    }

    public void storeToken(TrackingToken var1, String var2, int var3) throws UnableToClaimTokenException;

    public TrackingToken fetchToken(String var1, int var2) throws UnableToClaimTokenException;

    default public void extendClaim(String processorName, int segment) throws UnableToClaimTokenException {
        this.fetchToken(processorName, segment);
    }

    public void releaseClaim(String var1, int var2);

    default public void initializeSegment(TrackingToken token, String processorName, int segment) throws UnableToInitializeTokenException {
        throw new UnsupportedOperationException("Explicit initialization is not supported by this TokenStore implementation");
    }

    default public void deleteToken(String processorName, int segment) throws UnableToClaimTokenException {
        throw new UnsupportedOperationException("Explicit initialization (which is required to reliably delete tokens) is not supported by this TokenStore implementation");
    }

    default public boolean requiresExplicitSegmentInitialization() {
        return false;
    }

    public int[] fetchSegments(String var1);
}

