/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Spliterator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class CollectionUtils {
    private CollectionUtils() {
    }

    public static <S, T extends Collection<S>> T merge(T collection1, T collection2, Supplier<T> factoryMethod) {
        if (collection1 == null || collection1.isEmpty()) {
            return collection2;
        }
        if (collection2 == null || collection2.isEmpty()) {
            return collection1;
        }
        Collection combined = (Collection)factoryMethod.get();
        combined.addAll(collection1);
        combined.addAll(collection2);
        return (T)combined;
    }

    public static <R> Collection<R> asCollection(Object potentialCollection) {
        if (potentialCollection == null) {
            return Collections.emptyList();
        }
        if (potentialCollection instanceof Collection) {
            return (Collection)potentialCollection;
        }
        if (potentialCollection.getClass().isArray()) {
            return Arrays.asList((Object[])potentialCollection);
        }
        if (potentialCollection instanceof Stream) {
            return ((Stream)potentialCollection).collect(Collectors.toList());
        }
        if (potentialCollection instanceof Spliterator) {
            return StreamSupport.stream((Spliterator)potentialCollection, false).collect(Collectors.toList());
        }
        if (potentialCollection instanceof Iterable) {
            return StreamSupport.stream(((Iterable)potentialCollection).spliterator(), false).collect(Collectors.toList());
        }
        return Collections.singletonList(potentialCollection);
    }

    public static <T, C extends Collection<T>> C intersect(Collection<? extends T> collection1, Collection<? extends T> collection2, Supplier<C> collectionBuilder) {
        Collection result = (Collection)collectionBuilder.get();
        HashSet<T> items = new HashSet<T>(collection2);
        for (T next : collection1) {
            if (items.add(next)) continue;
            result.add(next);
        }
        return (C)result;
    }
}

