/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed.commandfilter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.distributed.CommandMessageFilter;
import org.axonframework.commandhandling.distributed.commandfilter.DenyCommandNameFilter;
import org.axonframework.commandhandling.distributed.commandfilter.OrCommandMessageFilter;

public class CommandNameFilter
implements CommandMessageFilter {
    private final Set<String> commandNames;

    public CommandNameFilter(Set<String> commandNames) {
        this.commandNames = new HashSet<String>(commandNames);
    }

    public CommandNameFilter(String commandName) {
        this(Collections.singleton(commandName));
    }

    @Override
    public boolean matches(CommandMessage<?> commandMessage) {
        return this.commandNames.contains(commandMessage.getCommandName());
    }

    @Override
    public CommandMessageFilter negate() {
        return new DenyCommandNameFilter(this.commandNames);
    }

    @Override
    public CommandMessageFilter and(CommandMessageFilter other) {
        if (other instanceof CommandNameFilter) {
            return new CommandNameFilter(this.commandNames.stream().filter(((CommandNameFilter)other).commandNames::contains).collect(Collectors.toSet()));
        }
        return t -> this.matches(t) && other.matches(t);
    }

    @Override
    public CommandMessageFilter or(CommandMessageFilter other) {
        if (other instanceof CommandNameFilter) {
            return new CommandNameFilter(Stream.concat(this.commandNames.stream(), ((CommandNameFilter)other).commandNames.stream()).collect(Collectors.toSet()));
        }
        return new OrCommandMessageFilter(this, other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandNameFilter that = (CommandNameFilter)o;
        return Objects.equals(this.commandNames, that.commandNames);
    }

    public int hashCode() {
        return Objects.hash(this.commandNames);
    }

    public String toString() {
        return "CommandNameFilter{commandNames=" + this.commandNames + '}';
    }
}

