/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.conversion;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class CachingSupplier<T>
implements Supplier<T> {
    private final AtomicReference<T> value = new AtomicReference();
    private final transient Supplier<T> delegate;

    public static <T> CachingSupplier<T> of(T value) {
        return new CachingSupplier<T>(value);
    }

    public static <T> CachingSupplier<T> of(Supplier<T> supplier) {
        if (supplier instanceof CachingSupplier) {
            return (CachingSupplier)supplier;
        }
        return new CachingSupplier<Supplier<T>>(supplier);
    }

    private CachingSupplier(Supplier<T> delegate) {
        this.delegate = delegate;
    }

    private CachingSupplier(T value) {
        this.value.set(value);
        this.delegate = () -> value;
    }

    @Override
    public T get() {
        T result = this.value.get();
        if (result == null) {
            result = this.value.updateAndGet(v -> v == null ? this.delegate.get() : v);
        }
        return result;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.get();
        stream.defaultWriteObject();
    }
}

