/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.conversion.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.axonframework.conversion.ContentTypeConverter;
import org.axonframework.conversion.ConversionException;

public class JsonNodeToByteArrayConverter
implements ContentTypeConverter<JsonNode, byte[]> {
    private final ObjectMapper objectMapper;

    public JsonNodeToByteArrayConverter(@Nonnull ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "The ObjectMapper may not be null.");
    }

    @Override
    @Nonnull
    public Class<JsonNode> expectedSourceType() {
        return JsonNode.class;
    }

    @Override
    @Nonnull
    public Class<byte[]> targetType() {
        return byte[].class;
    }

    @Override
    @Nullable
    public byte[] convert(@Nullable JsonNode input) {
        try {
            return this.objectMapper.writeValueAsBytes((Object)input);
        }
        catch (JsonProcessingException e) {
            throw new ConversionException("An error occurred while converting a JsonNode to byte[]", e);
        }
    }
}

