/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.conversion.converter;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.axonframework.conversion.ContentTypeConverter;
import org.axonframework.conversion.ConversionException;

public class InputStreamToByteArrayConverter
implements ContentTypeConverter<InputStream, byte[]> {
    @Override
    @Nonnull
    public Class<InputStream> expectedSourceType() {
        return InputStream.class;
    }

    @Override
    @Nonnull
    public Class<byte[]> targetType() {
        return byte[].class;
    }

    @Override
    @Nullable
    public byte[] convert(@Nullable InputStream input) {
        if (input == null) {
            return null;
        }
        try {
            return this.bytesFrom(input);
        }
        catch (IOException e) {
            throw new ConversionException("Unable to convert InputStream to byte[]. Error while reading from Stream.", e);
        }
    }

    private byte[] bytesFrom(InputStream original) throws IOException {
        int n;
        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        while (-1 != (n = original.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }
}

