/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.conversion.avro;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.message.BinaryMessageEncoder;
import org.axonframework.conversion.ContentTypeConverter;
import org.axonframework.conversion.ConversionException;
import org.axonframework.conversion.avro.AvroUtil;

public class GenericRecordToByteArrayConverter
implements ContentTypeConverter<GenericRecord, byte[]> {
    @Override
    @Nonnull
    public Class<GenericRecord> expectedSourceType() {
        return GenericRecord.class;
    }

    @Override
    @Nonnull
    public Class<byte[]> targetType() {
        return byte[].class;
    }

    @Override
    @Nullable
    public byte[] convert(@Nullable GenericRecord input) {
        byte[] byArray;
        if (input == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            new BinaryMessageEncoder(AvroUtil.genericData, input.getSchema()).encode((Object)input, (OutputStream)baos);
            baos.flush();
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConversionException("Cannot convert GenericRecord to bytes.", e);
            }
        }
        baos.close();
        return byArray;
    }
}

