/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.configuration.AbstractComponent;
import org.axonframework.common.configuration.Component;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.infra.ComponentDescriptor;

@Internal
public class LazyInitializedComponentDefinition<C, A extends C>
extends AbstractComponent<C, A> {
    private final ComponentBuilder<A> builder;
    private final AtomicReference<A> instanceReference = new AtomicReference();

    public LazyInitializedComponentDefinition(@Nonnull Component.Identifier<C> identifier, @Nonnull ComponentBuilder<A> builder) {
        super(identifier);
        this.builder = Objects.requireNonNull(builder, "The builder must not be null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public A doResolve(@Nonnull Configuration configuration) {
        A resolvedInstance = this.instanceReference.get();
        if (resolvedInstance != null) {
            return resolvedInstance;
        }
        LazyInitializedComponentDefinition lazyInitializedComponentDefinition = this;
        synchronized (lazyInitializedComponentDefinition) {
            if (this.instanceReference.get() == null) {
                this.instanceReference.set(this.builder.build(configuration));
            }
        }
        return this.instanceReference.get();
    }

    @Override
    public boolean isInstantiated() {
        return this.instanceReference.get() != null;
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        super.describeTo(descriptor);
        A instance = this.instanceReference.get();
        if (instance != null) {
            descriptor.describeProperty("instance", instance);
        } else {
            descriptor.describeProperty("builder", this.builder);
        }
    }
}

