/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.configuration;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.common.configuration.Component;
import org.axonframework.common.configuration.ComponentDefinition;
import org.axonframework.common.configuration.ComponentLifecycleHandler;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.LifecycleRegistry;
import org.axonframework.common.infra.ComponentDescriptor;

public abstract class AbstractComponent<C, A extends C>
implements ComponentDefinition.ComponentCreator<C>,
Component<C> {
    private final Component.Identifier<C> identifier;
    private final List<HandlerRegistration<? super A>> startHandlers = new CopyOnWriteArrayList<HandlerRegistration<? super A>>();
    private final List<HandlerRegistration<? super A>> shutdownHandlers = new CopyOnWriteArrayList<HandlerRegistration<? super A>>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    protected AbstractComponent(@Nonnull Component.Identifier<C> identifier, @Nonnull List<HandlerRegistration<A>> startHandlers, @Nonnull List<HandlerRegistration<A>> shutdownHandlers) {
        this(identifier);
        this.startHandlers.addAll((Collection)Objects.requireNonNull(startHandlers, "The start handlers must not be null."));
        this.shutdownHandlers.addAll((Collection)Objects.requireNonNull(shutdownHandlers, "The shutdown handlers must not be null."));
    }

    protected AbstractComponent(@Nonnull Component.Identifier<C> identifier) {
        this.identifier = Objects.requireNonNull(identifier, "The identifier must not be null.");
    }

    @Override
    public Component<C> createComponent() {
        return this;
    }

    @Override
    public ComponentDefinition<C> onStart(int phase, @Nonnull ComponentLifecycleHandler<C> handler) {
        this.startHandlers.add(new HandlerRegistration<C>(phase, Objects.requireNonNull(handler, "The start handler must not be null.")));
        return this;
    }

    @Override
    public ComponentDefinition<C> onShutdown(int phase, @Nonnull ComponentLifecycleHandler<C> handler) {
        this.shutdownHandlers.add(new HandlerRegistration<C>(phase, Objects.requireNonNull(handler, "The shutdown handler must not be null.")));
        return this;
    }

    @Override
    public Component.Identifier<C> identifier() {
        return this.identifier;
    }

    @Override
    public Class<C> rawType() {
        return this.identifier.typeAsClass();
    }

    @Override
    @Nullable
    public String name() {
        return this.identifier.name();
    }

    @Override
    public C resolve(@Nonnull Configuration configuration) {
        return (C)this.doResolve(Objects.requireNonNull(configuration, "The configuration must not be null."));
    }

    abstract A doResolve(@Nonnull Configuration var1);

    @Override
    public void initLifecycle(@Nonnull Configuration configuration, @Nonnull LifecycleRegistry lifecycleRegistry) {
        Objects.requireNonNull(configuration, "The configuration must not be null.");
        Objects.requireNonNull(lifecycleRegistry, "The lifecycle registry must not be null.");
        if (!this.initialized.getAndSet(true)) {
            this.startHandlers.forEach(startHandler -> lifecycleRegistry.onStart(startHandler.phase, () -> startHandler.handler.run(configuration, this.doResolve(configuration))));
            this.shutdownHandlers.forEach(shutdownHandler -> lifecycleRegistry.onShutdown(shutdownHandler.phase, () -> shutdownHandler.handler.run(configuration, this.doResolve(configuration))));
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized.get();
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("identifier", this.identifier);
        descriptor.describeProperty("initialized", this.isInitialized());
        descriptor.describeProperty("instantiated", this.isInstantiated());
    }

    public record HandlerRegistration<C>(int phase, @Nonnull ComponentLifecycleHandler<C> handler) {
        public HandlerRegistration {
            Objects.requireNonNull(handler, "The lifecycle handler must not be null.");
        }
    }
}

