/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.datasource.pool;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.avaje.datasource.delegate.ConnectionDelegator;
import org.avaje.datasource.pool.ConnectionPool;
import org.avaje.datasource.pool.ExtendedPreparedStatement;
import org.avaje.datasource.pool.PooledConnectionStatistics;
import org.avaje.datasource.pool.PstmtCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnection
extends ConnectionDelegator {
    private static final Logger logger = LoggerFactory.getLogger(PooledConnection.class);
    private static final String IDLE_CONNECTION_ACCESSED_ERROR = "Pooled Connection has been accessed whilst idle in the pool, via method: ";
    private static final String REASON_MAXAGE = "maxAge";
    private static final String REASON_IDLE = "idleTime";
    private static final String REASON_RESET = "reset";
    private static final int STATUS_IDLE = 88;
    private static final int STATUS_ACTIVE = 89;
    private static final int STATUS_ENDED = 87;
    private final String name;
    private final ConnectionPool pool;
    private final Connection connection;
    private final long creationTime;
    private final PstmtCache pstmtCache;
    private final Object pstmtMonitor = new Object();
    private final PooledConnectionStatistics stats = new PooledConnectionStatistics();
    private int status = 88;
    private String closeReason;
    private boolean longRunning;
    private boolean hadErrors;
    private long startUseTime;
    private long lastUseTime;
    private long exeStartNanos;
    private String lastStatement;
    private String createdByMethod;
    private StackTraceElement[] stackTrace;
    private final int maxStackTrace;
    private int slotId;
    private boolean resetIsolationReadOnlyRequired;

    public PooledConnection(ConnectionPool pool, int uniqueId, Connection connection) {
        super(connection);
        this.pool = pool;
        this.connection = connection;
        this.name = pool.getName() + "" + uniqueId;
        this.pstmtCache = new PstmtCache(pool.getPstmtCacheSize());
        this.maxStackTrace = pool.getMaxStackTraceSize();
        this.lastUseTime = this.creationTime = System.currentTimeMillis();
    }

    protected PooledConnection(String name) {
        super(null);
        this.name = name;
        this.pool = null;
        this.connection = null;
        this.pstmtCache = null;
        this.maxStackTrace = 0;
        this.lastUseTime = this.creationTime = System.currentTimeMillis();
    }

    int getSlotId() {
        return this.slotId;
    }

    void setSlotId(int slotId) {
        this.slotId = slotId;
    }

    String getName() {
        return this.name;
    }

    private String getNameSlot() {
        return this.name + ":" + this.slotId;
    }

    public String toString() {
        return this.getDescription();
    }

    private long getBusySeconds() {
        return (System.currentTimeMillis() - this.startUseTime) / 1000L;
    }

    String getDescription() {
        return "name[" + this.name + "] slot[" + this.slotId + "] startTime[" + this.getStartUseTime() + "] busySeconds[" + this.getBusySeconds() + "] createdBy[" + this.getCreatedByMethod() + "] stmt[" + this.getLastStatement() + "]";
    }

    String getFullDescription() {
        return "name[" + this.name + "] slot[" + this.slotId + "] startTime[" + this.getStartUseTime() + "] busySeconds[" + this.getBusySeconds() + "] stackTrace[" + this.getStackTraceAsString() + "] stmt[" + this.getLastStatement() + "]";
    }

    PooledConnectionStatistics getStatistics() {
        return this.stats;
    }

    boolean isLongRunning() {
        return this.longRunning;
    }

    public void setLongRunning(boolean longRunning) {
        this.longRunning = longRunning;
    }

    void closeConnectionFully(boolean logErrors) {
        block12: {
            block11: {
                block10: {
                    if (this.pool != null) {
                        this.pool.reportClosingConnection(this);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Closing Connection[{}] slot[{}] reason[{}] stats: {} , pstmtStats: {} ", new Object[]{this.name, this.slotId, this.closeReason, this.stats.getValues(false), this.pstmtCache.getDescription()});
                    }
                    try {
                        if (this.connection.isClosed()) {
                            logger.debug("Closing Connection[{}] that is already closed?", (Object)this.name);
                            return;
                        }
                    }
                    catch (SQLException ex) {
                        if (!logErrors) break block10;
                        logger.error("Error checking if connection [" + this.getNameSlot() + "] is closed", (Throwable)ex);
                    }
                }
                try {
                    for (ExtendedPreparedStatement ps : this.pstmtCache.values()) {
                        ps.closeDestroy();
                    }
                }
                catch (SQLException ex) {
                    if (!logErrors) break block11;
                    logger.warn("Error when closing connection Statements", (Throwable)ex);
                }
            }
            try {
                this.connection.close();
            }
            catch (SQLException ex) {
                if (!logErrors && !logger.isDebugEnabled()) break block12;
                logger.error("Error when fully closing connection [" + this.getFullDescription() + "]", (Throwable)ex);
            }
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: createStatement()");
        }
        try {
            return this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurreny) throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: createStatement()");
        }
        try {
            return this.connection.createStatement(resultSetType, resultSetConcurreny);
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnPreparedStatement(ExtendedPreparedStatement pstmt) {
        Object object = this.pstmtMonitor;
        synchronized (object) {
            if (!this.pstmtCache.returnStatement(pstmt)) {
                try {
                    pstmt.closeDestroy();
                }
                catch (SQLException e) {
                    logger.error("Error closing Pstmt", (Throwable)e);
                }
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int returnKeysFlag) throws SQLException {
        StringBuilder cacheKey = new StringBuilder(sql.length() + 50);
        cacheKey.append(sql);
        cacheKey.append(':').append(this.currentSchema);
        cacheKey.append(':').append(returnKeysFlag);
        return this.prepareStatement(sql, true, returnKeysFlag, cacheKey.toString());
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        StringBuilder cacheKey = new StringBuilder(sql.length() + 50);
        cacheKey.append(sql);
        cacheKey.append(':').append(this.currentSchema);
        return this.prepareStatement(sql, false, 0, cacheKey.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(String sql, boolean useFlag, int flag, String cacheKey) throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: prepareStatement()");
        }
        try {
            Object object = this.pstmtMonitor;
            synchronized (object) {
                this.lastStatement = sql;
                ExtendedPreparedStatement pstmt = this.pstmtCache.remove(cacheKey);
                if (pstmt != null) {
                    return pstmt;
                }
                PreparedStatement actualPstmt = useFlag ? this.connection.prepareStatement(sql, flag) : this.connection.prepareStatement(sql);
                return new ExtendedPreparedStatement(this, actualPstmt, sql, cacheKey);
            }
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurreny) throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: prepareStatement()");
        }
        try {
            this.lastStatement = sql;
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurreny);
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    void resetForUse() {
        this.status = 89;
        this.startUseTime = System.currentTimeMillis();
        this.exeStartNanos = System.nanoTime();
        this.createdByMethod = null;
        this.lastStatement = null;
        this.hadErrors = false;
        this.longRunning = false;
    }

    void markWithError() {
        this.hadErrors = true;
    }

    @Override
    public void close() throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: close()");
        }
        long durationNanos = System.nanoTime() - this.exeStartNanos;
        this.stats.add(durationNanos, this.hadErrors);
        if (this.hadErrors && !this.pool.validateConnection(this)) {
            this.pool.returnConnectionForceClose(this);
            return;
        }
        try {
            if (this.connection.getAutoCommit() != this.pool.isAutoCommit()) {
                this.connection.setAutoCommit(this.pool.isAutoCommit());
            }
            if (this.resetIsolationReadOnlyRequired) {
                this.resetIsolationReadOnly();
                this.resetIsolationReadOnlyRequired = false;
            }
            this.lastUseTime = System.currentTimeMillis();
            this.status = 88;
            this.pool.returnConnection(this);
        }
        catch (Exception ex) {
            logger.warn("Error when trying to return connection to pool, closing fully.", (Throwable)ex);
            this.pool.returnConnectionForceClose(this);
        }
    }

    private void resetIsolationReadOnly() throws SQLException {
        if (this.connection.getTransactionIsolation() != this.pool.getTransactionIsolation()) {
            this.connection.setTransactionIsolation(this.pool.getTransactionIsolation());
        }
        if (this.connection.isReadOnly()) {
            this.connection.setReadOnly(false);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                logger.warn("Closing Connection on finalize() - {}", (Object)this.getFullDescription());
                this.closeConnectionFully(false);
            }
        }
        catch (Exception e) {
            logger.error("Error when finalize is closing a connection? (unexpected)", (Throwable)e);
        }
        super.finalize();
    }

    private boolean exceedsMaxAge(long maxAgeMillis) {
        if (maxAgeMillis > 0L && this.creationTime < System.currentTimeMillis() - maxAgeMillis) {
            this.closeReason = REASON_MAXAGE;
            return true;
        }
        return false;
    }

    boolean shouldTrimOnReturn(long lastResetTime, long maxAgeMillis) {
        if (this.creationTime <= lastResetTime) {
            this.closeReason = REASON_RESET;
            return true;
        }
        return this.exceedsMaxAge(maxAgeMillis);
    }

    boolean shouldTrim(long usedSince, long createdSince) {
        if (this.lastUseTime < usedSince) {
            this.closeReason = REASON_IDLE;
            return true;
        }
        if (createdSince > 0L && createdSince > this.creationTime) {
            this.closeReason = REASON_MAXAGE;
            return true;
        }
        return false;
    }

    private long getStartUseTime() {
        return this.startUseTime;
    }

    long getLastUsedTime() {
        return this.lastUseTime;
    }

    private String getLastStatement() {
        return this.lastStatement;
    }

    void setLastStatement(String lastStatement) {
        this.lastStatement = lastStatement;
        if (logger.isTraceEnabled()) {
            logger.trace(".setLastStatement[" + lastStatement + "]");
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.resetIsolationReadOnlyRequired = true;
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: setTransactionIsolation()");
        }
        try {
            this.resetIsolationReadOnlyRequired = true;
            this.connection.setTransactionIsolation(level);
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: clearWarnings()");
        }
        this.connection.clearWarnings();
    }

    @Override
    public void commit() throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: commit()");
        }
        try {
            this.status = 87;
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: getAutoCommit()");
        }
        return this.connection.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: getCatalog()");
        }
        return this.connection.getCatalog();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: getMetaData()");
        }
        return this.connection.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: getTransactionIsolation()");
        }
        return this.connection.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: getTypeMap()");
        }
        return this.connection.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: getWarnings()");
        }
        return this.connection.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: isClosed()");
        }
        return this.connection.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: isReadOnly()");
        }
        return this.connection.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: nativeSQL()");
        }
        this.lastStatement = sql;
        return this.connection.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: prepareCall()");
        }
        this.lastStatement = sql;
        return this.connection.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurreny) throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: prepareCall()");
        }
        this.lastStatement = sql;
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurreny);
    }

    @Override
    public void rollback() throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: rollback()");
        }
        try {
            this.status = 87;
            this.connection.rollback();
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: setAutoCommit()");
        }
        try {
            this.connection.setAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: setCatalog()");
        }
        this.connection.setCatalog(catalog);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (this.status == 88) {
            throw new SQLException("Pooled Connection has been accessed whilst idle in the pool, via method: setTypeMap()");
        }
        this.connection.setTypeMap(map);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            return this.connection.setSavepoint();
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public Savepoint setSavepoint(String savepointName) throws SQLException {
        try {
            return this.connection.setSavepoint(savepointName);
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public void rollback(Savepoint sp) throws SQLException {
        try {
            this.connection.rollback(sp);
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint sp) throws SQLException {
        try {
            this.connection.releaseSavepoint(sp);
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public void setHoldability(int i) throws SQLException {
        try {
            this.connection.setHoldability(i);
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.connection.getHoldability();
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public Statement createStatement(int i, int x, int y) throws SQLException {
        try {
            return this.connection.createStatement(i, x, y);
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String s, int i, int x, int y) throws SQLException {
        try {
            return this.connection.prepareStatement(s, i, x, y);
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String s, int[] i) throws SQLException {
        try {
            return this.connection.prepareStatement(s, i);
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String s, String[] s2) throws SQLException {
        try {
            return this.connection.prepareStatement(s, s2);
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    @Override
    public CallableStatement prepareCall(String s, int i, int x, int y) throws SQLException {
        try {
            return this.connection.prepareCall(s, i, x, y);
        }
        catch (SQLException ex) {
            this.markWithError();
            throw ex;
        }
    }

    private String getCreatedByMethod() {
        if (this.createdByMethod != null) {
            return this.createdByMethod;
        }
        if (this.stackTrace == null) {
            return null;
        }
        for (int j = 0; j < this.stackTrace.length; ++j) {
            String methodLine = this.stackTrace[j].toString();
            if (this.skipElement(methodLine)) continue;
            this.createdByMethod = methodLine;
            return this.createdByMethod;
        }
        return null;
    }

    private boolean skipElement(String methodLine) {
        if (methodLine.startsWith("java.lang.")) {
            return true;
        }
        if (methodLine.startsWith("java.util.")) {
            return true;
        }
        if (methodLine.startsWith("org.avaje.datasource.")) {
            return true;
        }
        return methodLine.startsWith("com.avaje.ebean");
    }

    void setStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    private String getStackTraceAsString() {
        Object[] stackTrace = this.getStackTrace();
        if (stackTrace == null) {
            return "";
        }
        return Arrays.toString(stackTrace);
    }

    private StackTraceElement[] getStackTrace() {
        if (this.stackTrace == null) {
            return null;
        }
        ArrayList<StackTraceElement> filteredList = new ArrayList<StackTraceElement>();
        boolean include = false;
        for (int i = 0; i < this.stackTrace.length; ++i) {
            if (!include && !this.skipElement(this.stackTrace[i].toString())) {
                include = true;
            }
            if (!include || filteredList.size() >= this.maxStackTrace) continue;
            filteredList.add(this.stackTrace[i]);
        }
        return filteredList.toArray(new StackTraceElement[filteredList.size()]);
    }
}

