/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.classpath.scanner.internal.scanner.classpath.jboss;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.avaje.classpath.scanner.internal.UrlUtils;
import org.avaje.classpath.scanner.internal.scanner.classpath.ClassPathLocationScanner;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBossVFSv3ClassPathLocationScanner
implements ClassPathLocationScanner {
    private static final Logger LOG = LoggerFactory.getLogger(JBossVFSv3ClassPathLocationScanner.class);

    @Override
    public Set<String> findResourceNames(String location, URL locationUrl) throws IOException {
        String filePath = UrlUtils.toFilePath(locationUrl);
        String classPathRootOnDisk = filePath.substring(0, filePath.length() - location.length());
        if (!classPathRootOnDisk.endsWith("/")) {
            classPathRootOnDisk = classPathRootOnDisk + "/";
        }
        LOG.debug("Scanning starting at classpath root on JBoss VFS: " + classPathRootOnDisk);
        TreeSet<String> resourceNames = new TreeSet<String>();
        List files = VFS.getChild((String)filePath).getChildrenRecursively(VirtualFile::isFile);
        for (VirtualFile file : files) {
            resourceNames.add(file.getPathName().substring(classPathRootOnDisk.length()));
        }
        return resourceNames;
    }
}

