/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.classpath.scanner.internal.scanner.classpath.jboss;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import org.avaje.classpath.scanner.ClassPathScanException;
import org.avaje.classpath.scanner.internal.scanner.classpath.UrlResolver;

public class JBossVFSv2UrlResolver
implements UrlResolver {
    @Override
    public URL toStandardJavaUrl(URL url) throws IOException {
        try {
            Class<?> vfsClass = Class.forName("org.jboss.virtual.VFS");
            Class<?> vfsUtilsClass = Class.forName("org.jboss.virtual.VFSUtils");
            Class<?> virtualFileClass = Class.forName("org.jboss.virtual.VirtualFile");
            Method getRootMethod = vfsClass.getMethod("getRoot", URL.class);
            Method getRealURLMethod = vfsUtilsClass.getMethod("getRealURL", virtualFileClass);
            Object root = getRootMethod.invoke(null, url);
            return (URL)getRealURLMethod.invoke(null, root);
        }
        catch (Exception e) {
            throw new ClassPathScanException("JBoss VFS v2 call failed", e);
        }
    }
}

