/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import org.atmosphere.wasync.Client;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.RequestBuilder;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.impl.DefaultFunctionResolver;
import org.atmosphere.wasync.impl.DefaultRequestBuilder;
import org.atmosphere.wasync.impl.DefaultSocket;

public class DefaultClient
implements Client<RequestBuilder> {
    private static final String WASYNC_USER_AGENT = "wAsync/1.0";
    private AsyncHttpClient asyncHttpClient;

    @Override
    public Socket create() {
        this.createDefaultAsyncHttpClient(new Options.OptionsBuilder().reconnect(true).build());
        return this.getSocket(new Options.OptionsBuilder().runtime(this.asyncHttpClient, false).build());
    }

    @Override
    public Socket create(Options options) {
        this.asyncHttpClient = options.runtime();
        if (this.asyncHttpClient == null) {
            this.createDefaultAsyncHttpClient(options);
            options.runtime(this.asyncHttpClient);
        }
        return this.getSocket(options);
    }

    @Override
    public RequestBuilder newRequestBuilder() {
        DefaultRequestBuilder b = new DefaultRequestBuilder();
        return b.resolver(new DefaultFunctionResolver());
    }

    @Override
    public RequestBuilder newRequestBuilder(Class<RequestBuilder> clazz) {
        RequestBuilder b = null;
        try {
            b = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return b.resolver(new DefaultFunctionResolver());
    }

    protected Socket getSocket(Options options) {
        return new DefaultSocket(options);
    }

    private void createDefaultAsyncHttpClient(Options o) {
        AsyncHttpClientConfig.Builder config = new AsyncHttpClientConfig.Builder();
        config.setFollowRedirects(true).setRequestTimeoutInMs(o.requestTimeout()).setUserAgent(WASYNC_USER_AGENT);
        this.asyncHttpClient = new AsyncHttpClient(config.build());
    }
}

