/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocket;

public class Jetty8WebSocket
extends WebSocket {
    private final WebSocket.Connection connection;

    public Jetty8WebSocket(WebSocket.Connection connection, AtmosphereConfig config) {
        super(config);
        this.connection = connection;
    }

    public String toString() {
        return this.connection.toString();
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen();
    }

    @Override
    public WebSocket write(String s) throws IOException {
        logger.trace("WebSocket.write() for {}", (Object)(this.resource() != null ? this.resource().uuid() : ""));
        this.connection.sendMessage(s);
        return this;
    }

    @Override
    public WebSocket write(byte[] b, int offset, int length) throws IOException {
        logger.trace("WebSocket.write() for {}", (Object)(this.resource() != null ? this.resource().uuid() : ""));
        this.connection.sendMessage(b, offset, length);
        return this;
    }

    @Override
    public void close() {
        logger.trace("WebSocket.close() for AtmosphereResource {}", (Object)(this.resource() != null ? this.resource().uuid() : "null"));
        this.connection.close();
    }

    @Override
    public WebSocket flush(AtmosphereResponse r) throws IOException {
        logger.trace("WebSocket.flush() not supported by Jetty");
        return this;
    }
}

