/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.interceptor.InvokationOrder;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.Utils;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleResourceInterceptor
extends AtmosphereInterceptorAdapter {
    private final Logger logger = LoggerFactory.getLogger(IdleResourceInterceptor.class);
    private long maxInactiveTime = -1L;
    private AtmosphereConfig config;
    private Future<?> future;

    @Override
    public void configure(AtmosphereConfig config) {
        this.config = config;
        String maxInactive = config.getInitParameter("org.atmosphere.cpr.CometSupport.maxInactiveActivity");
        if (maxInactive != null) {
            this.maxInactiveTime = Long.parseLong(maxInactive);
        }
        this.start();
    }

    private void start() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        if (this.maxInactiveTime > 0L) {
            this.logger.info("{} started with idle timeout set to {}", (Object)IdleResourceInterceptor.class.getSimpleName(), (Object)this.maxInactiveTime);
            this.future = ExecutorsFactory.getScheduler(this.config).scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    IdleResourceInterceptor.this.idleResources();
                }
            }, 0L, 2L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void idleResources() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("{} monitoring {} AtmosphereResources", (Object)this.getClass().getSimpleName(), (Object)this.config.resourcesFactory().findAll().size());
        }
        for (AtmosphereResource r : this.config.resourcesFactory().findAll()) {
            if (Utils.pollableTransport(r.transport())) continue;
            AtmosphereRequest req = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false);
            try {
                if (req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") == null) {
                    this.logger.error("Invalid state {}", (Object)r);
                    r.removeFromAllBroadcasters();
                    this.config.resourcesFactory().unRegisterUuidForFindCandidate(r);
                    continue;
                }
                long l = (Long)req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity");
                if (this.logger.isTraceEnabled() && l > 0L) {
                    this.logger.trace("Expiring {} in {}", (Object)r.uuid(), (Object)(System.currentTimeMillis() - l));
                }
                if (l <= 0L || System.currentTimeMillis() - l <= this.maxInactiveTime) continue;
                try {
                    req.setAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity", -1L);
                    this.logger.debug("IdleResourceInterceptor disconnecting {}", (Object)r);
                    Future f = (Future)req.getAttribute("heartbeat.future");
                    if (f != null) {
                        f.cancel(false);
                    }
                    req.removeAttribute("heartbeat.future");
                    WebSocket webSocket = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).webSocket();
                    if (webSocket != null) {
                        webSocket.close();
                        continue;
                    }
                    ((AsynchronousProcessor)AsynchronousProcessor.class.cast(this.config.framework().getAsyncSupport())).endRequest((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r), true);
                }
                finally {
                    r.removeFromAllBroadcasters();
                    this.config.resourcesFactory().unRegisterUuidForFindCandidate(r);
                }
            }
            catch (Throwable e) {
                this.logger.warn("IdleResourceInterceptor", e);
            }
        }
    }

    public long maxInactiveTime() {
        return this.maxInactiveTime;
    }

    public IdleResourceInterceptor maxInactiveTime(long maxInactiveTime) {
        this.maxInactiveTime = maxInactiveTime;
        this.start();
        return this;
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (this.maxInactiveTime > 0L && !Utils.pollableTransport(r.transport())) {
            ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false).setAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity", System.currentTimeMillis());
        }
        return Action.CONTINUE;
    }

    @Override
    public InvokationOrder.PRIORITY priority() {
        return InvokationOrder.BEFORE_DEFAULT;
    }

    @Override
    public void destroy() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }
}

