/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.atmosphere.util.chmv8.ForkJoinPool;
import org.atmosphere.util.chmv8.ForkJoinWorkerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDK6ForkJoinPool
extends AbstractExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(JDK6ForkJoinPool.class);
    private final AbstractExecutorService forkJoinPool;
    private final boolean shared;

    public JDK6ForkJoinPool(boolean shared, final String threadName) {
        this.shared = shared;
        this.forkJoinPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), new ForkJoinPool.ForkJoinWorkerThreadFactory(){

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                return new JDK6ForkJoinWorkerThread(pool, JDK6ForkJoinPool.this.shared, threadName);
            }
        }, null, true);
    }

    public AbstractExecutorService pool() {
        return this.forkJoinPool;
    }

    @Override
    public void shutdown() {
        this.forkJoinPool.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.forkJoinPool.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.forkJoinPool.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.forkJoinPool.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.forkJoinPool.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.forkJoinPool.execute(command);
    }

    private static final class JDK6ForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        private final AtomicInteger count = new AtomicInteger();

        protected JDK6ForkJoinWorkerThread(ForkJoinPool pool, boolean shared, String threadName) {
            super(pool);
            this.setName((shared ? "Atmosphere-Shared" : threadName) + this.count.getAndIncrement());
        }
    }
}

