/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import javax.servlet.http.HttpServletRequest;
import org.atmosphere.container.version.Jetty9WebSocket;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty9WebSocketHandler
implements WebSocketListener {
    private static final Logger logger = LoggerFactory.getLogger(Jetty9WebSocketHandler.class);
    private final AtmosphereRequest request;
    private final AtmosphereFramework framework;
    private final WebSocketProcessor webSocketProcessor;
    private WebSocket webSocket;

    public Jetty9WebSocketHandler(HttpServletRequest request, AtmosphereFramework framework, WebSocketProcessor webSocketProcessor) {
        this.framework = framework;
        this.request = this.cloneRequest(request);
        this.webSocketProcessor = webSocketProcessor;
    }

    private AtmosphereRequest cloneRequest(HttpServletRequest request) {
        try {
            AtmosphereRequest r = AtmosphereRequest.wrap(request);
            return AtmosphereRequest.cloneRequest((HttpServletRequest)r, false, false, false);
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            throw new RuntimeException("Invalid WebSocket Request");
        }
    }

    public void onWebSocketBinary(byte[] data, int offset, int length) {
        logger.trace("WebSocket.onMessage (bytes)");
        this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, data, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketClose(int closeCode, String s) {
        logger.trace("onClose {}:{}", (Object)closeCode, (Object)s);
        try {
            this.webSocketProcessor.close(this.webSocket, closeCode);
        }
        finally {
            this.request.destroy();
        }
    }

    public void onWebSocketConnect(Session session) {
        logger.trace("WebSocket.onOpen.");
        this.webSocket = new Jetty9WebSocket(session, this.framework.getAtmosphereConfig());
        try {
            this.webSocketProcessor.open(this.webSocket, this.request, AtmosphereResponse.newInstance(this.framework.getAtmosphereConfig(), this.request, this.webSocket));
        }
        catch (Exception e) {
            logger.warn("Failed to connect to WebSocket", (Throwable)e);
        }
    }

    public void onWebSocketError(Throwable e) {
        logger.error("{}", e);
        this.onWebSocketClose(1006, "Unexpected error");
    }

    public void onWebSocketText(String s) {
        logger.trace("WebSocket.onMessage (bytes)");
        this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, s);
    }
}

