/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;

public class CookieUtil {
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final ThreadLocal<DateFormat> OLD_COOKIE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat(CookieUtil.OLD_COOKIE_PATTERN, Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            return df;
        }
    };
    private static final String tspecials = ",; ";
    private static final String ancientDate = OLD_COOKIE_FORMAT.get().format(new Date(10000L));

    public static boolean isToken(String value) {
        if (value == null) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    private static String escapeDoubleQuotes(String s) {
        if (s == null || s.length() == 0 || s.indexOf(34) == -1) {
            return s;
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String toString(Cookie c) {
        StringBuffer buf = new StringBuffer();
        buf.append(c.getName());
        buf.append("=");
        int newVersion = c.getVersion();
        CookieUtil.maybeQuote(buf, c.getValue());
        if (newVersion == 1) {
            buf.append("; Version=1");
            if (c.getComment() != null) {
                buf.append("; Comment=");
                CookieUtil.maybeQuote(buf, c.getComment());
            }
        }
        if (c.getDomain() != null) {
            buf.append("; Domain=");
            CookieUtil.maybeQuote(buf, c.getDomain());
        }
        if (c.getMaxAge() >= 0) {
            if (newVersion > 0) {
                buf.append("; Max-Age=");
                buf.append(c.getMaxAge());
            }
            if (newVersion == 0) {
                buf.append("; Expires=");
                if (c.getMaxAge() == 0) {
                    buf.append(ancientDate);
                } else {
                    OLD_COOKIE_FORMAT.get().format(new Date(System.currentTimeMillis() + (long)c.getMaxAge() * 1000L), buf, new FieldPosition(0));
                }
            }
        }
        if (c.getPath() != null) {
            buf.append("; Path=");
            CookieUtil.maybeQuote(buf, c.getPath());
        }
        if (c.getSecure()) {
            buf.append("; Secure");
        }
        if (c.isHttpOnly()) {
            buf.append("; HttpOnly");
        }
        return buf.toString();
    }

    private static void maybeQuote(StringBuffer buf, String value) {
        if (value == null || value.length() == 0) {
            buf.append("\"\"");
        } else if (CookieUtil.alreadyQuoted(value)) {
            buf.append('\"');
            buf.append(CookieUtil.escapeDoubleQuotes(value, 1, value.length() - 1));
            buf.append('\"');
        } else {
            buf.append(value);
        }
    }

    public static boolean alreadyQuoted(String value) {
        if (value == null || value.length() < 2) {
            return false;
        }
        return value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    private static String escapeDoubleQuotes(String s, int beginIndex, int endIndex) {
        if (s == null || s.length() == 0 || s.indexOf(34) == -1) {
            return s;
        }
        StringBuffer b = new StringBuffer();
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                b.append(c);
                if (++i >= endIndex) {
                    throw new IllegalArgumentException("Invalid escape character in cookie value.");
                }
                b.append(s.charAt(i));
                continue;
            }
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }
}

