/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.StringEscapeUtils;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONPAtmosphereInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(JSONPAtmosphereInterceptor.class);
    private String endChunk = "\"});";
    private String startChunk = "({\"message\" : \"";
    private AtmosphereConfig config;
    private static final String CONTENT_TYPE = "Content-Type: application/javascript; charset=utf-8";
    private static final String PATTERN = "[^A-Za-z0-9]";

    @Override
    public void configure(AtmosphereConfig config) {
        this.config = config;
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (Utils.webSocketMessage(r)) {
            return Action.CONTINUE;
        }
        final AtmosphereRequest request = r.getRequest();
        AtmosphereResponse response = r.getResponse();
        String uri = request.getRequestURI() == null ? "" : request.getRequestURI();
        boolean contain = uri.contains("jsonp");
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.JSONP) || contain) {
            super.inspect(r);
            if (contain) {
                this.startChunk = "(\"";
                this.endChunk = "\");\r\n\r\n";
            }
            response.setContentType(CONTENT_TYPE);
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
                ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptorAdapter(){

                    String callbackName() {
                        String jsonp;
                        String callback = JSONPAtmosphereInterceptor.this.escapeForJavaScript(request.getParameter("jsonpTransport")).replaceAll(JSONPAtmosphereInterceptor.PATTERN, "");
                        if (callback == null && (jsonp = JSONPAtmosphereInterceptor.this.escapeForJavaScript((String)JSONPAtmosphereInterceptor.this.config.properties().get("jsonpTransport")).replaceAll(JSONPAtmosphereInterceptor.PATTERN, "")) != null) {
                            callback = request.getParameter(jsonp);
                        }
                        return callback;
                    }

                    @Override
                    public void prePayload(AtmosphereResponse response, byte[] data, int offset, int length) {
                        String callbackName = this.callbackName();
                        response.write(callbackName + JSONPAtmosphereInterceptor.this.startChunk);
                    }

                    @Override
                    public byte[] transformPayload(AtmosphereResponse response, byte[] responseDraft, byte[] data) throws IOException {
                        String charEncoding = response.getCharacterEncoding() == null ? "UTF-8" : response.getCharacterEncoding();
                        return JSONPAtmosphereInterceptor.this.escapeForJavaScript(new String(responseDraft, charEncoding)).getBytes(charEncoding);
                    }

                    @Override
                    public void postPayload(AtmosphereResponse response, byte[] data, int offset, int length) {
                        response.write(JSONPAtmosphereInterceptor.this.endChunk, true);
                    }
                });
            } else {
                logger.warn("Unable to apply {}. Your AsyncIOWriter must implement {}", (Object)this.getClass().getName(), (Object)AtmosphereInterceptorWriter.class.getName());
            }
        }
        return Action.CONTINUE;
    }

    private String escapeForJavaScript(String str) {
        try {
            str = StringEscapeUtils.escapeJavaScript(str);
        }
        catch (Exception e) {
            logger.error("Failed to escape", (Throwable)e);
            str = null;
        }
        return str;
    }

    @Override
    public String toString() {
        return "JSONP Interceptor Support";
    }
}

