/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONPAtmosphereInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(JSONPAtmosphereInterceptor.class);

    @Override
    public Action inspect(AtmosphereResource r) {
        final AtmosphereRequest request = r.getRequest();
        final AtmosphereResponse response = r.getResponse();
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.JSONP)) {
            super.inspect(r);
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
                ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptorAdapter(){

                    String contentType() {
                        String c = response.getContentType();
                        if (c == null) {
                            c = (String)request.getAttribute(FrameworkConfig.EXPECTED_CONTENT_TYPE);
                        }
                        if (c == null) {
                            c = request.getContentType();
                        }
                        return c;
                    }

                    String callbackName() {
                        return request.getParameter("jsonpTransport");
                    }

                    @Override
                    public void prePayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                        String callbackName = this.callbackName();
                        String contentType = this.contentType();
                        response2.write(callbackName + "({\"message\" : ");
                        if (contentType != null && !contentType.contains("json")) {
                            response2.write("\"", true);
                        }
                    }

                    @Override
                    public void postPayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                        String contentType = this.contentType();
                        if (contentType != null && !contentType.contains("json")) {
                            response2.write("\"", true);
                        }
                        response2.write("});", true);
                    }
                });
            } else {
                logger.warn("Unable to apply {}. Your AsyncIOWriter must implement {}", (Object)this.getClass().getName(), (Object)AtmosphereInterceptorWriter.class.getName());
            }
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return "JSONP Interceptor Support";
    }
}

