/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometProcessor;
import org.atmosphere.container.JBossAsyncSupportWithWebSocket;
import org.atmosphere.container.JBossWebCometSupport;
import org.atmosphere.container.Tomcat7CometSupport;
import org.atmosphere.container.TomcatCometSupport;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereFrameworkInitializer;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereServlet
extends HttpServlet
implements org.apache.catalina.CometProcessor,
HttpEventServlet,
CometProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereServlet.class);
    protected final AtmosphereFrameworkInitializer initializer;

    public AtmosphereServlet() {
        this(false);
    }

    public AtmosphereServlet(boolean isFilter) {
        this(isFilter, true);
    }

    public AtmosphereServlet(boolean isFilter, boolean autoDetectHandlers) {
        this.initializer = new AtmosphereFrameworkInitializer(isFilter, autoDetectHandlers);
    }

    public void destroy() {
        this.initializer.destroy();
    }

    public void init(ServletConfig sc) throws ServletException {
        this.configureFramework(sc);
        super.init(sc);
    }

    protected AtmosphereServlet configureFramework(ServletConfig sc) throws ServletException {
        return this.configureFramework(sc, true);
    }

    protected AtmosphereServlet configureFramework(ServletConfig sc, boolean init) throws ServletException {
        this.initializer.configureFramework(sc, init, true, AtmosphereFramework.class);
        return this;
    }

    protected AtmosphereFramework newAtmosphereFramework() {
        return this.initializer.newAtmosphereFramework(AtmosphereFramework.class);
    }

    public AtmosphereFramework framework() {
        return this.initializer.framework();
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doTrace(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.initializer.framework().doCometSupport(AtmosphereRequest.wrap(req), AtmosphereResponse.wrap(res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(org.apache.catalina.CometEvent cometEvent) throws IOException, ServletException {
        HttpServletRequest req = cometEvent.getHttpServletRequest();
        HttpServletResponse res = cometEvent.getHttpServletResponse();
        req.setAttribute("CometEvent", (Object)cometEvent);
        if (!(this.initializer.framework().getAsyncSupport().supportWebSocket() || this.initializer.framework().isCometSupportSpecified || this.initializer.framework().isCometSupportConfigured.getAndSet(true))) {
            AsyncSupport asyncSupport = this.initializer.framework().asyncSupport;
            synchronized (asyncSupport) {
                if (!this.initializer.framework().asyncSupport.getClass().equals(TomcatCometSupport.class)) {
                    AsyncSupport current = this.initializer.framework().asyncSupport;
                    logger.warn("TomcatCometSupport is enabled, switching to it");
                    this.initializer.framework().asyncSupport = new TomcatCometSupport(this.initializer.framework().config);
                    if (current instanceof AsynchronousProcessor) {
                        ((AsynchronousProcessor)current).shutdown();
                    }
                    this.initializer.framework().asyncSupport.init(this.initializer.framework().config.getServletConfig());
                }
            }
        }
        this.initializer.framework().doCometSupport(AtmosphereRequest.wrap(req), AtmosphereResponse.wrap(res));
        String transport = cometEvent.getHttpServletRequest().getParameter("X-Atmosphere-Transport");
        if (transport != null && transport.equalsIgnoreCase("websocket")) {
            cometEvent.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(CometEvent cometEvent) throws IOException, ServletException {
        boolean webSocketSupported;
        block11: {
            HttpServletRequest req = cometEvent.getHttpServletRequest();
            HttpServletResponse res = cometEvent.getHttpServletResponse();
            req.setAttribute("CometEvent", (Object)cometEvent);
            if (!(this.initializer.framework().getAsyncSupport().supportWebSocket() || this.initializer.framework().isCometSupportSpecified || this.initializer.framework().isCometSupportConfigured.getAndSet(true))) {
                AsyncSupport asyncSupport = this.initializer.framework().asyncSupport;
                synchronized (asyncSupport) {
                    if (!this.initializer.framework().asyncSupport.getClass().equals(Tomcat7CometSupport.class)) {
                        AsyncSupport current = this.initializer.framework().asyncSupport;
                        logger.warn("TomcatCometSupport7 is enabled, switching to it");
                        this.initializer.framework().asyncSupport = new Tomcat7CometSupport(this.initializer.framework().config);
                        if (current instanceof AsynchronousProcessor) {
                            ((AsynchronousProcessor)current).shutdown();
                        }
                        this.initializer.framework().asyncSupport.init(this.initializer.framework().config.getServletConfig());
                    }
                }
            }
            this.initializer.framework().doCometSupport(AtmosphereRequest.wrap(req), AtmosphereResponse.wrap(res));
            String transport = cometEvent.getHttpServletRequest().getParameter("X-Atmosphere-Transport");
            boolean bl = webSocketSupported = transport != null && transport.equalsIgnoreCase("websocket");
            if (!webSocketSupported) {
                try {
                    String[] e;
                    Enumeration connection = req.getHeaders("Connection");
                    if (connection == null || !connection.hasMoreElements()) break block11;
                    for (String upgrade : e = ((String)connection.nextElement()).toString().split(",")) {
                        if (!upgrade.trim().equalsIgnoreCase("Upgrade")) continue;
                        webSocketSupported = true;
                        break;
                    }
                }
                catch (Exception ex) {
                    logger.trace("", (Throwable)ex);
                }
            }
        }
        if (webSocketSupported) {
            cometEvent.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(HttpEvent httpEvent) throws IOException, ServletException {
        boolean isWebSocket;
        HttpServletRequest req = httpEvent.getHttpServletRequest();
        HttpServletResponse res = httpEvent.getHttpServletResponse();
        req.setAttribute("HttpEvent", (Object)httpEvent);
        if (!this.initializer.framework().isCometSupportSpecified && !this.initializer.framework().isCometSupportConfigured.getAndSet(true)) {
            AsyncSupport asyncSupport = this.initializer.framework().asyncSupport;
            synchronized (asyncSupport) {
                if (!this.initializer.framework().asyncSupport.getClass().equals(JBossWebCometSupport.class) && !this.initializer.framework().asyncSupport.getClass().equals(JBossAsyncSupportWithWebSocket.class)) {
                    AsyncSupport current = this.initializer.framework().asyncSupport;
                    logger.warn("JBossWebCometSupport is enabled, switching to it");
                    this.initializer.framework().asyncSupport = new JBossWebCometSupport(this.initializer.framework().config);
                    if (current instanceof AsynchronousProcessor) {
                        ((AsynchronousProcessor)current).shutdown();
                    }
                    this.initializer.framework().asyncSupport.init(this.initializer.framework().config.getServletConfig());
                }
            }
        }
        boolean bl = isWebSocket = req.getHeader("Upgrade") != null;
        if (isWebSocket && this.initializer.framework().asyncSupport.getClass().equals(JBossAsyncSupportWithWebSocket.class)) {
            logger.trace("Dispatching websocket event: " + httpEvent);
            ((JBossAsyncSupportWithWebSocket)this.initializer.framework().asyncSupport).dispatch(httpEvent);
        } else {
            logger.trace("Dispatching comet event: " + httpEvent);
            this.initializer.framework().doCometSupport(AtmosphereRequest.wrap(req), AtmosphereResponse.wrap(res));
        }
    }
}

