/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util.annotation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import org.atmosphere.util.annotation.FileIterator;
import org.atmosphere.util.annotation.InputStreamIterator;
import org.atmosphere.util.annotation.ZipFileIterator;

final class ClassFileIterator {
    private final FileIterator fileIterator;
    private final String[] pkgNameFilter;
    private ZipFileIterator zipIterator;
    private boolean isFile;
    private final InputStreamIterator inputStreamIterator;

    ClassFileIterator() throws IOException {
        this(ClassFileIterator.classPath(), null);
    }

    ClassFileIterator(File[] filesOrDirectories, String[] pkgNameFilter) throws IOException {
        this.fileIterator = new FileIterator(filesOrDirectories);
        this.pkgNameFilter = pkgNameFilter;
        this.inputStreamIterator = null;
    }

    ClassFileIterator(InputStream[] filesOrDirectories, String[] pkgNameFilter) throws IOException {
        this.fileIterator = null;
        this.pkgNameFilter = pkgNameFilter;
        this.inputStreamIterator = new InputStreamIterator(filesOrDirectories);
    }

    public String getName() {
        return this.zipIterator == null ? this.fileIterator.getFile().getPath() : this.zipIterator.getEntry().getName();
    }

    public boolean isFile() {
        return this.isFile;
    }

    public InputStream next() throws IOException {
        while (this.fileIterator != null) {
            if (this.zipIterator == null) {
                File file = this.fileIterator.next();
                if (file == null) {
                    return null;
                }
                String name = file.getName();
                if (name.endsWith(".class")) {
                    this.isFile = true;
                    return new FileInputStream(file);
                }
                if (!this.fileIterator.isRootFile() || !ClassFileIterator.endsWithIgnoreCase(name, ".jar")) continue;
                this.zipIterator = new ZipFileIterator(new ZipFile(file), this.pkgNameFilter);
                continue;
            }
            InputStream is = this.zipIterator.next();
            if (is == null) {
                this.zipIterator = null;
                continue;
            }
            this.isFile = false;
            return is;
        }
        return this.inputStreamIterator.next();
    }

    private static File[] classPath() {
        String[] fileNames = System.getProperty("java.class.path").split(File.pathSeparator);
        File[] files = new File[fileNames.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(fileNames[i]);
        }
        return files;
    }

    private static boolean endsWithIgnoreCase(String value, String suffix) {
        int n = suffix.length();
        return value.regionMatches(true, value.length() - n, suffix, 0, n);
    }
}

