/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.config.managed;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.atmosphere.config.managed.Decoder;
import org.atmosphere.config.managed.Encoder;
import org.atmosphere.config.managed.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Invoker {
    private static final Logger logger = LoggerFactory.getLogger(Invoker.class);

    public static Object decode(List<Decoder<?, ?>> decoders, Object instanceType) {
        Object decodedObject = Invoker.matchDecoder(instanceType, decoders);
        if (instanceType == null) {
            logger.trace("No Encoder matching {}", instanceType);
        }
        return decodedObject;
    }

    public static Object invokeMethod(Method method, Object objectToInvoke, Object ... parameters) {
        Object objectToEncode = null;
        boolean hasMatch = false;
        try {
            objectToEncode = method.invoke(objectToInvoke, parameters);
            hasMatch = true;
        }
        catch (IllegalAccessException e) {
            logger.trace("", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.trace("", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.trace("", (Throwable)e);
        }
        catch (Throwable e) {
            logger.error("", e);
        }
        if (!hasMatch) {
            logger.trace("No Method's Arguments {} matching {}", (Object)method.getName(), objectToInvoke);
        }
        return objectToEncode;
    }

    public static Object encode(List<Encoder<?, ?>> encoders, Object objectToEncode) {
        Object encodedObject = Invoker.matchEncoder(objectToEncode, encoders);
        if (encodedObject == null) {
            logger.trace("No Encoder matching {}", objectToEncode);
        }
        return encodedObject;
    }

    public static Object all(List<Encoder<?, ?>> encoders, List<Decoder<?, ?>> decoders, Object instanceType, Object objectToInvoke, Method method) {
        Object decodedObject = Invoker.decode(decoders, instanceType);
        if (instanceType == null) {
            logger.trace("No Encoder matching {}", instanceType);
        }
        decodedObject = decodedObject == null ? instanceType : decodedObject;
        logger.trace("{} .on {}", (Object)method.getName(), decodedObject);
        Object objectToEncode = Invoker.invokeMethod(method, objectToInvoke, decodedObject);
        Object encodedObject = null;
        if (objectToEncode != null) {
            encodedObject = Invoker.encode(encoders, objectToEncode);
        }
        return encodedObject == null ? objectToEncode : encodedObject;
    }

    public static Object matchDecoder(Object instanceType, List<Decoder<?, ?>> decoders) {
        Object decodedObject = decoders.size() == 0 ? instanceType : null;
        for (Decoder<?, ?> d : decoders) {
            Class<?>[] typeArguments = TypeResolver.resolveArguments(d.getClass(), Decoder.class);
            if (instanceType == null || typeArguments.length <= 0 || !typeArguments[0].isAssignableFrom(instanceType.getClass())) continue;
            logger.trace("{} is trying to decode {}", d, instanceType);
            try {
                decodedObject = d.decode(instanceType);
            }
            catch (Exception e) {
                logger.trace("", (Throwable)e);
            }
        }
        return decodedObject;
    }

    public static Object matchEncoder(Object instanceType, List<Encoder<?, ?>> encoders) {
        if (instanceType == null) {
            return null;
        }
        Object encodedObject = encoders.size() == 0 ? instanceType : null;
        for (Encoder<?, ?> d : encoders) {
            Class<?>[] typeArguments = TypeResolver.resolveArguments(d.getClass(), Encoder.class);
            if (instanceType == null || typeArguments.length <= 0 || !typeArguments[0].isAssignableFrom(instanceType.getClass())) continue;
            logger.trace("{} is trying to encode {}", d, instanceType);
            encodedObject = d.encode(instanceType);
        }
        return encodedObject;
    }
}

