/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import java.util.ArrayList;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.managed.AtmosphereHandlerServiceInterceptor;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.util.IntrospectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereAnnotation(value=AtmosphereHandlerService.class)
public class AtmosphereHandlerServiceProcessor
implements Processor<AtmosphereHandler> {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereHandlerServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<AtmosphereHandler> annotatedClass) {
        try {
            AtmosphereInterceptor aa;
            AtmosphereHandlerService a = annotatedClass.getAnnotation(AtmosphereHandlerService.class);
            AnnotationUtil.atmosphereConfig(a.atmosphereConfig(), framework);
            AnnotationUtil.filters(a.broadcastFilters(), framework);
            Class[] interceptors = a.interceptors();
            ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
            for (Class i : interceptors) {
                try {
                    AtmosphereInterceptor ai = (AtmosphereInterceptor)framework.newClassInstance(AtmosphereHandler.class, i);
                    l.add(ai);
                }
                catch (Throwable e) {
                    logger.warn("", e);
                }
            }
            if (a.path().contains("{")) {
                framework.interceptors().add(framework.newClassInstance(AtmosphereInterceptor.class, AtmosphereHandlerServiceInterceptor.class));
            }
            if ((aa = AnnotationUtil.listeners(a.listeners(), framework)) != null) {
                l.add(aa);
            }
            framework.sessionSupport(a.supportSession());
            AtmosphereHandler handler = (AtmosphereHandler)framework.newClassInstance(AtmosphereHandler.class, annotatedClass);
            for (String s : a.properties()) {
                String[] nv = s.split("=");
                IntrospectionUtils.setProperty((Object)handler, (String)nv[0], (String)nv[1]);
                IntrospectionUtils.addProperty((Object)handler, (String)nv[0], (String)nv[1]);
            }
            framework.addAtmosphereHandler(a.path(), handler, AnnotationUtil.broadcaster(framework, a.broadcaster(), a.path()), l);
            framework.setBroadcasterCacheClassName(a.broadcasterCache().getName());
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
    }
}

