/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.dns.DnsPtrRecord;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordEncoder;
import io.netty.util.internal.StringUtil;

public class DefaultDnsRecordEncoder
implements DnsRecordEncoder {
    protected DefaultDnsRecordEncoder() {
    }

    @Override
    public final void encodeQuestion(DnsQuestion question, ByteBuf out) throws Exception {
        this.encodeName(question.name(), out);
        out.writeShort(question.type().intValue());
        out.writeShort(question.dnsClass());
    }

    @Override
    public void encodeRecord(DnsRecord record, ByteBuf out) throws Exception {
        if (record instanceof DnsQuestion) {
            this.encodeQuestion((DnsQuestion)record, out);
        } else if (record instanceof DnsPtrRecord) {
            this.encodePtrRecord((DnsPtrRecord)record, out);
        } else if (record instanceof DnsRawRecord) {
            this.encodeRawRecord((DnsRawRecord)record, out);
        } else {
            throw new UnsupportedMessageTypeException(StringUtil.simpleClassName((Object)record));
        }
    }

    private void encodePtrRecord(DnsPtrRecord record, ByteBuf out) throws Exception {
        this.encodeName(record.name(), out);
        out.writeShort(record.type().intValue());
        out.writeShort(record.dnsClass());
        out.writeInt((int)record.timeToLive());
        this.encodeName(record.hostname(), out);
    }

    private void encodeRawRecord(DnsRawRecord record, ByteBuf out) throws Exception {
        this.encodeName(record.name(), out);
        out.writeShort(record.type().intValue());
        out.writeShort(record.dnsClass());
        out.writeInt((int)record.timeToLive());
        ByteBuf content = record.content();
        int contentLen = content.readableBytes();
        out.writeShort(contentLen);
        out.writeBytes(content, content.readerIndex(), contentLen);
    }

    protected void encodeName(String name, ByteBuf buf) throws Exception {
        String[] parts;
        for (String part : parts = StringUtil.split((String)name, (char)'.')) {
            int partLen = part.length();
            buf.writeByte(partLen);
            if (partLen == 0) continue;
            ByteBufUtil.writeAscii((ByteBuf)buf, (CharSequence)part);
        }
        buf.writeByte(0);
    }
}

