/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.resolver.NameResolver;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.ClientStats;
import org.asynchttpclient.HostStats;
import org.asynchttpclient.Realm;
import org.asynchttpclient.SslEngineFactory;
import org.asynchttpclient.channel.ChannelPool;
import org.asynchttpclient.channel.ChannelPoolPartitioning;
import org.asynchttpclient.channel.NoopChannelPool;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.OnLastHttpContentCallback;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.channel.DefaultChannelPool;
import org.asynchttpclient.netty.channel.EpollTransportFactory;
import org.asynchttpclient.netty.channel.KQueueTransportFactory;
import org.asynchttpclient.netty.channel.NioTransportFactory;
import org.asynchttpclient.netty.channel.TransportFactory;
import org.asynchttpclient.netty.handler.AsyncHttpClientHandler;
import org.asynchttpclient.netty.handler.HttpHandler;
import org.asynchttpclient.netty.handler.WebSocketHandler;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.netty.ssl.DefaultSslEngineFactory;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    public static final String HTTP_CLIENT_CODEC = "http";
    public static final String SSL_HANDLER = "ssl";
    public static final String SOCKS_HANDLER = "socks";
    public static final String INFLATER_HANDLER = "inflater";
    public static final String CHUNKED_WRITER_HANDLER = "chunked-writer";
    public static final String WS_DECODER_HANDLER = "ws-decoder";
    public static final String WS_FRAME_AGGREGATOR = "ws-aggregator";
    public static final String WS_COMPRESSOR_HANDLER = "ws-compressor";
    public static final String WS_ENCODER_HANDLER = "ws-encoder";
    public static final String AHC_HTTP_HANDLER = "ahc-http";
    public static final String AHC_WS_HANDLER = "ahc-ws";
    public static final String LOGGING_HANDLER = "logging";
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    private final AsyncHttpClientConfig config;
    private final SslEngineFactory sslEngineFactory;
    private final EventLoopGroup eventLoopGroup;
    private final boolean allowReleaseEventLoopGroup;
    private final Bootstrap httpBootstrap;
    private final Bootstrap wsBootstrap;
    private final long handshakeTimeout;
    private final ChannelPool channelPool;
    private final ChannelGroup openChannels;
    private AsyncHttpClientHandler wsHandler;

    public ChannelManager(AsyncHttpClientConfig config, Timer nettyTimer) {
        TransportFactory<NioSocketChannel, NioEventLoopGroup> transportFactory;
        this.config = config;
        this.sslEngineFactory = config.getSslEngineFactory() != null ? config.getSslEngineFactory() : new DefaultSslEngineFactory();
        try {
            this.sslEngineFactory.init(config);
        }
        catch (SSLException e) {
            throw new RuntimeException("Could not initialize sslEngineFactory", e);
        }
        ChannelPool channelPool = config.getChannelPool();
        if (channelPool == null) {
            channelPool = config.isKeepAlive() ? new DefaultChannelPool(config, nettyTimer) : NoopChannelPool.INSTANCE;
        }
        this.channelPool = channelPool;
        this.openChannels = new DefaultChannelGroup("asyncHttpClient", (EventExecutor)GlobalEventExecutor.INSTANCE);
        this.handshakeTimeout = config.getHandshakeTimeout();
        ThreadFactory threadFactory = config.getThreadFactory() != null ? config.getThreadFactory() : new DefaultThreadFactory(config.getThreadPoolName());
        boolean bl = this.allowReleaseEventLoopGroup = config.getEventLoopGroup() == null;
        if (this.allowReleaseEventLoopGroup) {
            transportFactory = config.isUseNativeTransport() ? this.getNativeTransportFactory() : NioTransportFactory.INSTANCE;
            this.eventLoopGroup = transportFactory.newEventLoopGroup(config.getIoThreadsCount(), threadFactory);
        } else {
            this.eventLoopGroup = config.getEventLoopGroup();
            if (this.eventLoopGroup instanceof NioEventLoopGroup) {
                transportFactory = NioTransportFactory.INSTANCE;
            } else if (this.eventLoopGroup instanceof EpollEventLoopGroup) {
                transportFactory = new EpollTransportFactory();
            } else if (this.eventLoopGroup instanceof KQueueEventLoopGroup) {
                transportFactory = new KQueueTransportFactory();
            } else {
                throw new IllegalArgumentException("Unknown event loop group " + this.eventLoopGroup.getClass().getSimpleName());
            }
        }
        this.httpBootstrap = this.newBootstrap(transportFactory, this.eventLoopGroup, config);
        this.wsBootstrap = this.newBootstrap(transportFactory, this.eventLoopGroup, config);
        this.httpBootstrap.option(ChannelOption.AUTO_READ, (Object)false);
    }

    public static boolean isSslHandlerConfigured(ChannelPipeline pipeline) {
        return pipeline.get(SSL_HANDLER) != null;
    }

    private Bootstrap newBootstrap(ChannelFactory<? extends Channel> channelFactory, EventLoopGroup eventLoopGroup, AsyncHttpClientConfig config) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(channelFactory)).group(eventLoopGroup)).option(ChannelOption.ALLOCATOR, (Object)(config.getAllocator() != null ? config.getAllocator() : ByteBufAllocator.DEFAULT))).option(ChannelOption.TCP_NODELAY, (Object)config.isTcpNoDelay())).option(ChannelOption.SO_REUSEADDR, (Object)config.isSoReuseAddress())).option(ChannelOption.SO_KEEPALIVE, (Object)config.isSoKeepAlive())).option(ChannelOption.AUTO_CLOSE, (Object)false);
        if (config.getConnectTimeout() > 0) {
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.getConnectTimeout());
        }
        if (config.getSoLinger() >= 0) {
            bootstrap.option(ChannelOption.SO_LINGER, (Object)config.getSoLinger());
        }
        if (config.getSoSndBuf() >= 0) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)config.getSoSndBuf());
        }
        if (config.getSoRcvBuf() >= 0) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)config.getSoRcvBuf());
        }
        for (Map.Entry<ChannelOption<Object>, Object> entry : config.getChannelOptions().entrySet()) {
            bootstrap.option(entry.getKey(), entry.getValue());
        }
        return bootstrap;
    }

    private TransportFactory<? extends Channel, ? extends EventLoopGroup> getNativeTransportFactory() {
        String nativeTransportFactoryClassName = null;
        if (PlatformDependent.isOsx()) {
            nativeTransportFactoryClassName = "org.asynchttpclient.netty.channel.KQueueTransportFactory";
        } else if (!PlatformDependent.isWindows()) {
            nativeTransportFactoryClassName = "org.asynchttpclient.netty.channel.EpollTransportFactory";
        }
        try {
            if (nativeTransportFactoryClassName != null) {
                return (TransportFactory)Class.forName(nativeTransportFactoryClassName).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("No suitable native transport (epoll or kqueue) available");
    }

    public void configureBootstraps(NettyRequestSender requestSender) {
        final HttpHandler httpHandler = new HttpHandler(this.config, this, requestSender);
        this.wsHandler = new WebSocketHandler(this.config, this, requestSender);
        final LoggingHandler loggingHandler = new LoggingHandler(LogLevel.TRACE);
        this.httpBootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline().addLast(ChannelManager.HTTP_CLIENT_CODEC, (ChannelHandler)ChannelManager.this.newHttpClientCodec()).addLast(ChannelManager.INFLATER_HANDLER, (ChannelHandler)ChannelManager.this.newHttpContentDecompressor()).addLast(ChannelManager.CHUNKED_WRITER_HANDLER, (ChannelHandler)new ChunkedWriteHandler()).addLast(ChannelManager.AHC_HTTP_HANDLER, (ChannelHandler)httpHandler);
                if (LOGGER.isTraceEnabled()) {
                    pipeline.addFirst(ChannelManager.LOGGING_HANDLER, (ChannelHandler)loggingHandler);
                }
                if (ChannelManager.this.config.getHttpAdditionalChannelInitializer() != null) {
                    ChannelManager.this.config.getHttpAdditionalChannelInitializer().accept(ch);
                }
            }
        });
        this.wsBootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline().addLast(ChannelManager.HTTP_CLIENT_CODEC, (ChannelHandler)ChannelManager.this.newHttpClientCodec()).addLast(ChannelManager.AHC_WS_HANDLER, (ChannelHandler)ChannelManager.this.wsHandler);
                if (ChannelManager.this.config.isEnableWebSocketCompression()) {
                    pipeline.addBefore(ChannelManager.AHC_WS_HANDLER, ChannelManager.WS_COMPRESSOR_HANDLER, (ChannelHandler)WebSocketClientCompressionHandler.INSTANCE);
                }
                if (LOGGER.isDebugEnabled()) {
                    pipeline.addFirst(ChannelManager.LOGGING_HANDLER, (ChannelHandler)loggingHandler);
                }
                if (ChannelManager.this.config.getWsAdditionalChannelInitializer() != null) {
                    ChannelManager.this.config.getWsAdditionalChannelInitializer().accept(ch);
                }
            }
        });
    }

    private HttpContentDecompressor newHttpContentDecompressor() {
        if (this.config.isKeepEncodingHeader()) {
            return new HttpContentDecompressor(){

                protected String getTargetContentEncoding(String contentEncoding) {
                    return contentEncoding;
                }
            };
        }
        return new HttpContentDecompressor();
    }

    public final void tryToOfferChannelToPool(Channel channel, AsyncHandler<?> asyncHandler, boolean keepAlive, Object partitionKey) {
        if (channel.isActive() && keepAlive) {
            LOGGER.debug("Adding key: {} for channel {}", partitionKey, (Object)channel);
            Channels.setDiscard(channel);
            try {
                asyncHandler.onConnectionOffer(channel);
            }
            catch (Exception e) {
                LOGGER.error("onConnectionOffer crashed", (Throwable)e);
            }
            if (!this.channelPool.offer(channel, partitionKey)) {
                this.closeChannel(channel);
            }
        } else {
            this.closeChannel(channel);
        }
    }

    public Channel poll(Uri uri, String virtualHost, ProxyServer proxy, ChannelPoolPartitioning connectionPoolPartitioning) {
        Object partitionKey = connectionPoolPartitioning.getPartitionKey(uri, virtualHost, proxy);
        return this.channelPool.poll(partitionKey);
    }

    public void removeAll(Channel connection) {
        this.channelPool.removeAll(connection);
    }

    private void doClose() {
        ChannelGroupFuture groupFuture = this.openChannels.close();
        this.channelPool.destroy();
        groupFuture.addListener(future -> this.sslEngineFactory.destroy());
    }

    public void close() {
        if (this.allowReleaseEventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully((long)this.config.getShutdownQuietPeriod(), (long)this.config.getShutdownTimeout(), TimeUnit.MILLISECONDS).addListener(future -> this.doClose());
        } else {
            this.doClose();
        }
    }

    public void closeChannel(Channel channel) {
        LOGGER.debug("Closing Channel {} ", (Object)channel);
        Channels.setDiscard(channel);
        this.removeAll(channel);
        Channels.silentlyCloseChannel(channel);
    }

    public void registerOpenChannel(Channel channel) {
        this.openChannels.add((Object)channel);
    }

    private HttpClientCodec newHttpClientCodec() {
        return new HttpClientCodec(this.config.getHttpClientCodecMaxInitialLineLength(), this.config.getHttpClientCodecMaxHeaderSize(), this.config.getHttpClientCodecMaxChunkSize(), false, this.config.isValidateResponseHeaders(), this.config.getHttpClientCodecInitialBufferSize());
    }

    private SslHandler createSslHandler(String peerHost, int peerPort) {
        SSLEngine sslEngine = this.sslEngineFactory.newSslEngine(this.config, peerHost, peerPort);
        SslHandler sslHandler = new SslHandler(sslEngine);
        if (this.handshakeTimeout > 0L) {
            sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeout);
        }
        return sslHandler;
    }

    public Future<Channel> updatePipelineForHttpTunneling(ChannelPipeline pipeline, Uri requestUri) {
        Future whenHanshaked = null;
        if (pipeline.get(HTTP_CLIENT_CODEC) != null) {
            pipeline.remove(HTTP_CLIENT_CODEC);
        }
        if (requestUri.isSecured()) {
            if (!ChannelManager.isSslHandlerConfigured(pipeline)) {
                SslHandler sslHandler = this.createSslHandler(requestUri.getHost(), requestUri.getExplicitPort());
                whenHanshaked = sslHandler.handshakeFuture();
                pipeline.addBefore(INFLATER_HANDLER, SSL_HANDLER, (ChannelHandler)sslHandler);
            }
            pipeline.addAfter(SSL_HANDLER, HTTP_CLIENT_CODEC, (ChannelHandler)this.newHttpClientCodec());
        } else {
            pipeline.addBefore(AHC_HTTP_HANDLER, HTTP_CLIENT_CODEC, (ChannelHandler)this.newHttpClientCodec());
        }
        if (requestUri.isWebSocket()) {
            pipeline.addAfter(AHC_HTTP_HANDLER, AHC_WS_HANDLER, (ChannelHandler)this.wsHandler);
            if (this.config.isEnableWebSocketCompression()) {
                pipeline.addBefore(AHC_WS_HANDLER, WS_COMPRESSOR_HANDLER, (ChannelHandler)WebSocketClientCompressionHandler.INSTANCE);
            }
            pipeline.remove(AHC_HTTP_HANDLER);
        }
        return whenHanshaked;
    }

    public SslHandler addSslHandler(ChannelPipeline pipeline, Uri uri, String virtualHost, boolean hasSocksProxyHandler) {
        int peerPort;
        String peerHost;
        if (virtualHost != null) {
            int i = virtualHost.indexOf(58);
            if (i == -1) {
                peerHost = virtualHost;
                peerPort = uri.getSchemeDefaultPort();
            } else {
                peerHost = virtualHost.substring(0, i);
                peerPort = Integer.valueOf(virtualHost.substring(i + 1));
            }
        } else {
            peerHost = uri.getHost();
            peerPort = uri.getExplicitPort();
        }
        SslHandler sslHandler = this.createSslHandler(peerHost, peerPort);
        if (hasSocksProxyHandler) {
            pipeline.addAfter(SOCKS_HANDLER, SSL_HANDLER, (ChannelHandler)sslHandler);
        } else {
            pipeline.addFirst(SSL_HANDLER, (ChannelHandler)sslHandler);
        }
        return sslHandler;
    }

    public Future<Bootstrap> getBootstrap(Uri uri, NameResolver<InetAddress> nameResolver, final ProxyServer proxy) {
        Promise promise = ImmediateEventExecutor.INSTANCE.newPromise();
        if (uri.isWebSocket() && proxy == null) {
            return promise.setSuccess((Object)this.wsBootstrap);
        }
        if (proxy != null && proxy.getProxyType().isSocks()) {
            Bootstrap socksBootstrap = this.httpBootstrap.clone();
            final ChannelHandler httpBootstrapHandler = socksBootstrap.config().handler();
            nameResolver.resolve(proxy.getHost()).addListener(whenProxyAddress -> {
                if (whenProxyAddress.isSuccess()) {
                    socksBootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                            httpBootstrapHandler.handlerAdded(ctx);
                            super.handlerAdded(ctx);
                        }

                        protected void initChannel(Channel channel) throws Exception {
                            Socks4ProxyHandler socksProxyHandler;
                            InetSocketAddress proxyAddress = new InetSocketAddress((InetAddress)whenProxyAddress.get(), proxy.getPort());
                            Realm realm = proxy.getRealm();
                            String username = realm != null ? realm.getPrincipal() : null;
                            String password = realm != null ? realm.getPassword() : null;
                            switch (proxy.getProxyType()) {
                                case SOCKS_V4: {
                                    socksProxyHandler = new Socks4ProxyHandler((SocketAddress)proxyAddress, username);
                                    break;
                                }
                                case SOCKS_V5: {
                                    socksProxyHandler = new Socks5ProxyHandler((SocketAddress)proxyAddress, username, password);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Only SOCKS4 and SOCKS5 supported at the moment.");
                                }
                            }
                            channel.pipeline().addFirst(ChannelManager.SOCKS_HANDLER, (ChannelHandler)socksProxyHandler);
                        }
                    });
                    promise.setSuccess((Object)socksBootstrap);
                } else {
                    promise.setFailure(whenProxyAddress.cause());
                }
            });
        } else {
            promise.setSuccess((Object)this.httpBootstrap);
        }
        return promise;
    }

    public void upgradePipelineForWebSockets(ChannelPipeline pipeline) {
        pipeline.addAfter(HTTP_CLIENT_CODEC, WS_ENCODER_HANDLER, (ChannelHandler)new WebSocket08FrameEncoder(true));
        pipeline.addAfter(WS_ENCODER_HANDLER, WS_DECODER_HANDLER, (ChannelHandler)new WebSocket08FrameDecoder(false, this.config.isEnableWebSocketCompression(), this.config.getWebSocketMaxFrameSize()));
        if (this.config.isAggregateWebSocketFrameFragments()) {
            pipeline.addAfter(WS_DECODER_HANDLER, WS_FRAME_AGGREGATOR, (ChannelHandler)new WebSocketFrameAggregator(this.config.getWebSocketMaxBufferSize()));
        }
        pipeline.remove(HTTP_CLIENT_CODEC);
    }

    private OnLastHttpContentCallback newDrainCallback(NettyResponseFuture<?> future, final Channel channel, final boolean keepAlive, final Object partitionKey) {
        return new OnLastHttpContentCallback(future){

            @Override
            public void call() {
                ChannelManager.this.tryToOfferChannelToPool(channel, this.future.getAsyncHandler(), keepAlive, partitionKey);
            }
        };
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future) {
        this.drainChannelAndOffer(channel, future, future.isKeepAlive(), future.getPartitionKey());
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future, boolean keepAlive, Object partitionKey) {
        Channels.setAttribute(channel, this.newDrainCallback(future, channel, keepAlive, partitionKey));
    }

    public ChannelPool getChannelPool() {
        return this.channelPool;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public ClientStats getClientStats() {
        Map totalConnectionsPerHost = this.openChannels.stream().map(Channel::remoteAddress).filter(a -> a.getClass() == InetSocketAddress.class).map(a -> (InetSocketAddress)a).map(InetSocketAddress::getHostString).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Map<String, Long> idleConnectionsPerHost = this.channelPool.getIdleChannelCountPerHost();
        Map<String, HostStats> statsPerHost = totalConnectionsPerHost.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            long totalConnectionCount = (Long)entry.getValue();
            long idleConnectionCount = idleConnectionsPerHost.getOrDefault(entry.getKey(), 0L);
            long activeConnectionCount = totalConnectionCount - idleConnectionCount;
            return new HostStats(activeConnectionCount, idleConnectionCount);
        }));
        return new ClientStats(statsPerHost);
    }

    public boolean isOpen() {
        return this.channelPool.isOpen();
    }
}

