/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.ssl;

import io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.netty.util.internal.EmptyArrays;
import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InsecureTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Logger logger = LoggerFactory.getLogger(InsecureTrustManagerFactory.class);
    public static final TrustManagerFactory INSTANCE = new InsecureTrustManagerFactory();
    private static final TrustManager tm = new X509ExtendedTrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String s) {
            this.log("client", chain);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String s, Socket socket) {
            this.log("client", chain);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String s, SSLEngine sslEngine) {
            this.log("client", chain);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String s) {
            this.log("server", chain);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String s, Socket socket) {
            this.log("server", chain);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String s, SSLEngine sslEngine) {
            this.log("server", chain);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EmptyArrays.EMPTY_X509_CERTIFICATES;
        }

        private void log(String type, X509Certificate[] chain) {
            logger.debug("Accepting a {} certificate: {}", (Object)type, (Object)chain[0].getSubjectDN());
        }
    };

    private InsecureTrustManagerFactory() {
    }

    protected void engineInit(KeyStore keyStore) throws Exception {
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
    }

    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{tm};
    }
}

