/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.cookie;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.asynchttpclient.cookie.Cookie;
import org.asynchttpclient.util.StringUtils;

public final class CookieEncoder {
    private static final Comparator<Cookie> COOKIE_COMPARATOR = new Comparator<Cookie>(){

        @Override
        public int compare(Cookie c1, Cookie c2) {
            int len1;
            String path1 = c1.getPath();
            String path2 = c2.getPath();
            int len2 = path2 == null ? Integer.MAX_VALUE : path2.length();
            int diff = len2 - (len1 = path1 == null ? Integer.MAX_VALUE : path1.length());
            if (diff != 0) {
                return diff;
            }
            return -1;
        }
    };

    private CookieEncoder() {
    }

    public static String encode(Collection<Cookie> cookies) {
        StringBuilder sb = StringUtils.stringBuilder();
        if (cookies.isEmpty()) {
            return "";
        }
        if (cookies.size() == 1) {
            Cookie cookie = cookies.iterator().next();
            if (cookie != null) {
                CookieEncoder.add(sb, cookie.getName(), cookie.getValue(), cookie.isWrap());
            }
        } else {
            Cookie[] cookiesSorted = cookies.toArray(new Cookie[cookies.size()]);
            Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
            for (Cookie cookie : cookiesSorted) {
                if (cookie == null) continue;
                CookieEncoder.add(sb, cookie.getName(), cookie.getValue(), cookie.isWrap());
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    private static void add(StringBuilder sb, String name, String val, boolean wrap) {
        if (val == null) {
            val = "";
        }
        sb.append(name);
        sb.append('=');
        if (wrap) {
            sb.append('\"').append(val).append('\"');
        } else {
            sb.append(val);
        }
        sb.append(';');
        sb.append(' ');
    }
}

